/*
 * Samsung Exynos5 SoC series Sensor driver
 *
 *
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef FIMC_IS_DEVICE_5EA_REG_H
#define FIMC_IS_DEVICE_5EA_REG_H

/*
 * Preview Frame Time
 * 1. HIGH		= 24 FPS ~ 30 FPS (MAX)
 * 2. NORMAL	= 15 FPS ~ 30 FPS (MAX)
 * 3. LOW		=  5 FPS ~ 10 FPS
 */

#define FRTIME_30	0x014D
#define FRTIME_24	0x01A1
#define FRTIME_15	0x029A
#define FRTIME_10	0x03E8
#define FRTIME_5	0x07D0

#define HIG_MAXFRTIME	FRTIME_24
#define HIG_MINFRTIME	FRTIME_30

#define NOR_MAXFRTIME	FRTIME_15
#define NOR_MINFRTIME	FRTIME_30

#define LOW_MAXFRTIME	FRTIME_5
#define LOW_MINFRTIME	FRTIME_10

/* Capture Frame Time */
/* 1. NORMAL = 5 FPS ~ 15 FPS(MAX) */
#define CAP_MAXFRTIME	FRTIME_5
#define CAP_MINFRTIME	FRTIME_15

#define PCFG_FORMAT_YUV		0x05
#define PCFG_FORMAT_MJPEG	0x09

#define PCFG_FMT_BASE		0x02E6
#define PCFG_FRTIME_BASE	0x02FE
#define PCFG_SIZE		48

/***********************************************************************
 # Preview #
	1. Default	: 1280 X 960
	2. 1080p	: 1920 X 1080
	3. 720p		: 1280 X 720
	4. 480p		:  720 X 480
	5. VGA		:  640 X 480
 # Capture #
	1. 5M		: 2560 X 1920
	2. 3M		: 2048 X 1536
	3. 2M		: 1600 X 1200
	4. 1M		: 1024 X 768
	5. VGA		:  640 X 480
***********************************************************************/

/***************************************************
//	name: 	S5K3AAEX EVT2 setfile
//	ver:		v2.61
//	history:
//	v0.0	start from 040908 setfile
//	v1.0	arange register
//	v1.01	change MCLK(25Mhz) and Frame rate(7fps)
//	v2.0	adjust register setting for 3AA EVT2
//		- color correction, RGB shding off, hsync start position, Mirror, fps
//		- Color Tuning, YGRPDLY
//	v2.1	change Frame rate(7.5fps) and Total gain to x4
//		(because of reducing visual noise at low illumination)
//		- change BPRM AGC Max and FrameAE start
//		improve AE speed
//	v2.2	modify AWB G gain and solve 50hz flicker detection fail in 25MHz 7.5fps
//	v2.3	Adjust gamma, Dark Slice, white point, Hue gain,
//		White Balance B control, Y gain On, Digital Clamp On
//		lower AWB G gain
//	v2.4	Adjust AE window weight, Y Gamma, WhitePoint, Shading and BPR Max Thres.
//	v2.41	Adjust AE/AWB window and AWB internal window boundary to decrease
//			skin color tracking
//	v2.411	special version for PSCDS
//	v2.412	RGB shading off
//	v2.5	Lens change STW to Sekonix
//		adjust White point and Y shading Coef (RGB shading off)
//	v2.6	New Tuning because of Full YC off and YCbCr Coef change
//		Gamma, Dark Slice, color matrix (not use), Color suppress
//		R Gain and DBPR agc MIN/MAX
//	v2.61	VCK inversion(data rising)
//
***************************************************/

static const struct s5k5ea_reg_item s5k5ea_init_reg1[] = {
	{0xFCFC, 0xD000},
	{0x0010, 0x0001},
	{0x1030, 0x0000},
	{0x0014, 0x0001},
};

static const struct s5k5ea_reg_item s5k5ea_init_reg2[] = {
	{0x0028, 0x2000},
	{0x002A, 0x31E4},
	{0x0F12, 0xB570},	// 200031E4
	{0x0F12, 0x4E17},	// 200031E6
	{0x0F12, 0x257F},	// 200031E8
	{0x0F12, 0x4C17},	// 200031EA
	{0x0F12, 0x2000},	// 200031EC
	{0x0F12, 0xF000},	// 200031EE
	{0x0F12, 0xFA69},   // 200031F0
	{0x0F12, 0x6266},	// 200031F2
	{0x0F12, 0x62A5},	// 200031F4
	{0x0F12, 0x4C16},	// 200031F6
	{0x0F12, 0x4814},	// 200031F8
	{0x0F12, 0x63E0},	// 200031FA
	{0x0F12, 0x4816},	// 200031FC
	{0x0F12, 0x4915},	// 200031FE
	{0x0F12, 0x6101},	// 20003200
	{0x0F12, 0x4916},	// 20003202
	{0x0F12, 0x4816},	// 20003204
	{0x0F12, 0xF000},	// 20003206
	{0x0F12, 0xFA63},	// 20003208
	{0x0F12, 0x4916},	// 2000320A
	{0x0F12, 0x4816},	// 2000320C
	{0x0F12, 0xF000},	// 2000320E
	{0x0F12, 0xFA5F},	// 20003210
	{0x0F12, 0x4916},	// 20003212
	{0x0F12, 0x4816},	// 20003214
	{0x0F12, 0xF000},	// 20003216
	{0x0F12, 0xFA5B},	// 20003218
	{0x0F12, 0x4916},	// 2000321A
	{0x0F12, 0x2000},	// 2000321C
	{0x0F12, 0x8008},	// 2000321E
	{0x0F12, 0x4915},	// 20003220
	{0x0F12, 0x4816},	// 20003222
	{0x0F12, 0xF000},	// 20003224
	{0x0F12, 0xFA54},	// 20003226
	{0x0F12, 0x4912},	// 20003228
	{0x0F12, 0x1D09},	// 2000322A
	{0x0F12, 0x6008},	// 2000322C
	{0x0F12, 0x4620},	// 2000322E
	{0x0F12, 0x4913},	// 20003230
	{0x0F12, 0x3080},	// 20003232
	{0x0F12, 0x6141},	// 20003234
	{0x0F12, 0x4813},	// 20003236
	{0x0F12, 0x67E0},	// 20003238
	{0x0F12, 0x4913},	// 2000323A
	{0x0F12, 0x4813},	// 2000323C
	{0x0F12, 0xF000},	// 2000323E
	{0x0F12, 0xFA47},	// 20003240
	{0x0F12, 0xBD70},	// 20003242
	{0x0F12, 0x0000},	// 20003244
	{0x0F12, 0x5EA1},	// 20003246
	{0x0F12, 0x2F34},	// 20003248
	{0x0F12, 0x2000},	// 2000324A
	{0x0F12, 0x3299},	// 2000324C
	{0x0F12, 0x2000},	// 2000324E
	{0x0F12, 0x0008},	// 20003250
	{0x0F12, 0x2000},	// 20003252
	{0x0F12, 0x32FF},	// 20003254
	{0x0F12, 0x2000},	// 20003256
	{0x0F12, 0x0148},	// 20003258
	{0x0F12, 0x2000},	// 2000325A
	{0x0F12, 0x33A3},	// 2000325C
	{0x0F12, 0x2000},	// 2000325E
	{0x0F12, 0x5361},	// 20003260
	{0x0F12, 0x0000},	// 20003262
	{0x0F12, 0x33C3},	// 20003264
	{0x0F12, 0x2000},	// 20003266
	{0x0F12, 0xCCC1},	// 20003268
	{0x0F12, 0x0000},	// 2000326A
	{0x0F12, 0x34C5},	// 2000326C
	{0x0F12, 0x2000},	// 2000326E
	{0x0F12, 0x67D7},	// 20003270
	{0x0F12, 0x0000},	// 20003272
	{0x0F12, 0x3798},	// 20003274
	{0x0F12, 0x2000},	// 20003276
	{0x0F12, 0x3521},	// 20003278
	{0x0F12, 0x2000},	// 2000327A
	{0x0F12, 0x745B},	// 2000327C
	{0x0F12, 0x0000},	// 2000327E
	{0x0F12, 0x35D3},	// 20003280
	{0x0F12, 0x2000},	// 20003282
	{0x0F12, 0x360F},	// 20003284
	{0x0F12, 0x2000},	// 20003286
	{0x0F12, 0x3637},	// 20003288
	{0x0F12, 0x2000},	// 2000328A
	{0x0F12, 0x50F9},	// 2000328C
	{0x0F12, 0x0000},	// 2000328E
	{0x0F12, 0xBA40},	// 20003290
	{0x0F12, 0x4770},	// 20003292
	{0x0F12, 0xBAC0},	// 20003294
	{0x0F12, 0x4770},	// 20003296
	{0x0F12, 0xB570},	// 20003298
	{0x0F12, 0x48F5},	// 2000329A
	{0x0F12, 0x8C00},	// 2000329C
	{0x0F12, 0x07C0},	// 2000329E
	{0x0F12, 0xD028},	// 200032A0
	{0x0F12, 0x49F4},	// 200032A2
	{0x0F12, 0x8848},	// 200032A4
	{0x0F12, 0x8809},	// 200032A6
	{0x0F12, 0x0400},	// 200032A8
	{0x0F12, 0x4308},	// 200032AA
	{0x0F12, 0x4CF2},	// 200032AC
	{0x0F12, 0x8A25},	// 200032AE
	{0x0F12, 0x4AF2},	// 200032B0
	{0x0F12, 0x2101},	// 200032B2
	{0x0F12, 0x8151},	// 200032B4
	{0x0F12, 0x4621},	// 200032B6
	{0x0F12, 0x3920},	// 200032B8
	{0x0F12, 0x6989},	// 200032BA
	{0x0F12, 0x233D},	// 200032BC
	{0x0F12, 0x5C5E},	// 200032BE
	{0x0F12, 0x4BEF},	// 200032C0
	{0x0F12, 0x2E00},	// 200032C2
	{0x0F12, 0xD005},	// 200032C4
	{0x0F12, 0x3140},	// 200032C6
	{0x0F12, 0x8B89},	// 200032C8
	{0x0F12, 0x2902},	// 200032CA
	{0x0F12, 0xD015},	// 200032CC
	{0x0F12, 0x2100},	// 200032CE
	{0x0F12, 0x8219},	// 200032D0
	{0x0F12, 0x4EEB},	// 200032D2
	{0x0F12, 0x2100},	// 200032D4
	{0x0F12, 0x3620},	// 200032D6
	{0x0F12, 0x8031},	// 200032D8
	{0x0F12, 0x03C6},	// 200032DA
	{0x0F12, 0x0C36},	// 200032DC
	{0x0F12, 0x825E},	// 200032DE
	{0x0F12, 0x8151},	// 200032E0
	{0x0F12, 0x2106},	// 200032E2
	{0x0F12, 0xF000},	// 200032E4
	{0x0F12, 0xF9FA},	// 200032E6
	{0x0F12, 0x8220},	// 200032E8
	{0x0F12, 0x207D},	// 200032EA
	{0x0F12, 0x0180},	// 200032EC
	{0x0F12, 0xF000},	// 200032EE
	{0x0F12, 0xF9FB},	// 200032F0
	{0x0F12, 0x8225},	// 200032F2
	{0x0F12, 0xF000},	// 200032F4
	{0x0F12, 0xF9FE},	// 200032F6
	{0x0F12, 0xBD70},	// 200032F8
	{0x0F12, 0x2101},	// 200032FA
	{0x0F12, 0xE7E8},	// 200032FC
	{0x0F12, 0xB5F8},	// 200032FE
	{0x0F12, 0x49E0},	// 20003300
	{0x0F12, 0x880A},	// 20003302
	{0x0F12, 0x2A00},	// 20003304
	{0x0F12, 0xD114},	// 20003306
	{0x0F12, 0x4DDC},	// 20003308
	{0x0F12, 0x89AA},	// 2000330A
	{0x0F12, 0x2A00},	// 2000330C
	{0x0F12, 0xD010},	// 2000330E
	{0x0F12, 0x2700},	// 20003310
	{0x0F12, 0x2800},	// 20003312
	{0x0F12, 0xD00E},	// 20003314
	{0x0F12, 0x8848},	// 20003316
	{0x0F12, 0xF000},	// 20003318
	{0x0F12, 0xF9E6},	// 2000331A
	{0x0F12, 0x48D8},	// 2000331C
	{0x0F12, 0x3020},	// 2000331E
	{0x0F12, 0x8007},	// 20003320
	{0x0F12, 0x200A},	// 20003322
	{0x0F12, 0xF000},	// 20003324
	{0x0F12, 0xF9E0},	// 20003326
	{0x0F12, 0x2001},	// 20003328
	{0x0F12, 0x8168},	// 2000332A
	{0x0F12, 0x200A},	// 2000332C
	{0x0F12, 0xF000},	// 2000332E
	{0x0F12, 0xF9DB},	// 20003330
	{0x0F12, 0xBDF8},	// 20003332
	{0x0F12, 0x48CF},	// 20003334
	{0x0F12, 0x8841},	// 20003336
	{0x0F12, 0x8800},	// 20003338
	{0x0F12, 0x0409},	// 2000333A
	{0x0F12, 0x4301},	// 2000333C
	{0x0F12, 0x0348},	// 2000333E
	{0x0F12, 0x0C00},	// 20003340
	{0x0F12, 0x4CCD},	// 20003342
	{0x0F12, 0x8A26},	// 20003344
	{0x0F12, 0x49CE},	// 20003346
	{0x0F12, 0x8248},	// 20003348
	{0x0F12, 0x816F},	// 2000334A
	{0x0F12, 0x4ACC},	// 2000334C
	{0x0F12, 0x2101},	// 2000334E
	{0x0F12, 0x3220},	// 20003350
	{0x0F12, 0x8011},	// 20003352
	{0x0F12, 0x8220},	// 20003354
	{0x0F12, 0x207D},	// 20003356
	{0x0F12, 0x00C0},	// 20003358
	{0x0F12, 0xF000},	// 2000335A
	{0x0F12, 0xF9C5},	// 2000335C
	{0x0F12, 0x8226},	// 2000335E
	{0x0F12, 0xBDF8},	// 20003360
	{0x0F12, 0xB570},	// 20003362
	{0x0F12, 0x4605},	// 20003364
	{0x0F12, 0x4CC8},	// 20003366
	{0x0F12, 0x8820},	// 20003368
	{0x0F12, 0x2800},	// 2000336A
	{0x0F12, 0xD10E},	// 2000336C
	{0x0F12, 0x48C7},	// 2000336E
	{0x0F12, 0x2108},	// 20003370
	{0x0F12, 0x8041},	// 20003372
	{0x0F12, 0x2601},	// 20003374
	{0x0F12, 0x8006},	// 20003376
	{0x0F12, 0xF000},	// 20003378
	{0x0F12, 0xF9C2},	// 2000337A
	{0x0F12, 0x48BE},	// 2000337C
	{0x0F12, 0x49C4},	// 2000337E
	{0x0F12, 0x8201},	// 20003380
	{0x0F12, 0x48C4},	// 20003382
	{0x0F12, 0x8BC0},	// 20003384
	{0x0F12, 0xF000},	// 20003386
	{0x0F12, 0xF9AF},	// 20003388
	{0x0F12, 0x8026},	// 2000338A
	{0x0F12, 0x48BF},	// 2000338C
	{0x0F12, 0x3040},	// 2000338E
	{0x0F12, 0x8880},	// 20003390
	{0x0F12, 0x2D00},	// 20003392
	{0x0F12, 0xD002},	// 20003394
	{0x0F12, 0x2102},	// 20003396
	{0x0F12, 0x4008},	// 20003398
	{0x0F12, 0xBD70},	// 2000339A
	{0x0F12, 0x07C0},	// 2000339C
	{0x0F12, 0x0FC0},	// 2000339E
	{0x0F12, 0xBD70},	// 200033A0
	{0x0F12, 0xB570},	// 200033A2
	{0x0F12, 0x4CB9},	// 200033A4
	{0x0F12, 0x3460},	// 200033A6
	{0x0F12, 0x8A25},	// 200033A8
	{0x0F12, 0x2004},	// 200033AA
	{0x0F12, 0x4385},	// 200033AC
	{0x0F12, 0x2000},	// 200033AE
	{0x0F12, 0xF7FF},	// 200033B0
	{0x0F12, 0xFFD7},	// 200033B2
	{0x0F12, 0x0080},	// 200033B4
	{0x0F12, 0x4328},	// 200033B6
	{0x0F12, 0x8220},	// 200033B8
	{0x0F12, 0x2021},	// 200033BA
	{0x0F12, 0x0200},	// 200033BC
	{0x0F12, 0x8060},	// 200033BE
	{0x0F12, 0xBD70},	// 200033C0
	{0x0F12, 0xB5F8},	// 200033C2
	{0x0F12, 0x2001},	// 200033C4
	{0x0F12, 0xF7FF},	// 200033C6
	{0x0F12, 0xFFCC},	// 200033C8
	{0x0F12, 0x4CB2},	// 200033CA
	{0x0F12, 0x2101},	// 200033CC
	{0x0F12, 0x3420},	// 200033CE
	{0x0F12, 0x2802},	// 200033D0
	{0x0F12, 0xD01C},	// 200033D2
	{0x0F12, 0x2000},	// 200033D4
	{0x0F12, 0x81A0},	// 200033D6
	{0x0F12, 0x48AC},	// 200033D8
	{0x0F12, 0x89A2},	// 200033DA
	{0x0F12, 0x8042},	// 200033DC
	{0x0F12, 0x2101},	// 200033DE
	{0x0F12, 0x8001},	// 200033E0
	{0x0F12, 0x4FAC},	// 200033E2
	{0x0F12, 0x8BF8},	// 200033E4
	{0x0F12, 0xF000},	// 200033E6
	{0x0F12, 0xF97F},	// 200033E8
	{0x0F12, 0x4EA8},	// 200033EA
	{0x0F12, 0x3620},	// 200033EC
	{0x0F12, 0x8A71},	// 200033EE
	{0x0F12, 0x48A9},	// 200033F0
	{0x0F12, 0x4DAA},	// 200033F2
	{0x0F12, 0x2900},	// 200033F4
	{0x0F12, 0xD002},	// 200033F6
	{0x0F12, 0x8902},	// 200033F8
	{0x0F12, 0x2A00},	// 200033FA
	{0x0F12, 0xD009},	// 200033FC
	{0x0F12, 0x2101},	// 200033FE
	{0x0F12, 0x03C9},	// 20003400
	{0x0F12, 0x8069},	// 20003402
	{0x0F12, 0x80E9},	// 20003404
	{0x0F12, 0x2100},	// 20003406
	{0x0F12, 0x80A9},	// 20003408
	{0x0F12, 0x8129},	// 2000340A
	{0x0F12, 0xE01E},	// 2000340C
	{0x0F12, 0x81A1},	// 2000340E
	{0x0F12, 0xE7E2},	// 20003410
	{0x0F12, 0x8069},	// 20003412
	{0x0F12, 0x8AB1},	// 20003414
	{0x0F12, 0x80E9},	// 20003416
	{0x0F12, 0x8AF1},	// 20003418
	{0x0F12, 0xB209},	// 2000341A
	{0x0F12, 0x80A9},	// 2000341C
	{0x0F12, 0x8B32},	// 2000341E
	{0x0F12, 0xB212},	// 20003420
	{0x0F12, 0x812A},	// 20003422
	{0x0F12, 0x8B73},	// 20003424
	{0x0F12, 0x469C},	// 20003426
	{0x0F12, 0x8BB3},	// 20003428
	{0x0F12, 0x469E},	// 2000342A
	{0x0F12, 0x4663},	// 2000342C
	{0x0F12, 0x2B00},	// 2000342E
	{0x0F12, 0xD104},	// 20003430
	{0x0F12, 0x17CB},	// 20003432
	{0x0F12, 0x0F5B},	// 20003434
	{0x0F12, 0x1859},	// 20003436
	{0x0F12, 0x10C9},	// 20003438
	{0x0F12, 0x80A9},	// 2000343A
	{0x0F12, 0x4671},	// 2000343C
	{0x0F12, 0x2900},	// 2000343E
	{0x0F12, 0xD104},	// 20003440
	{0x0F12, 0x17D1},	// 20003442
	{0x0F12, 0x0F49},	// 20003444
	{0x0F12, 0x1889},	// 20003446
	{0x0F12, 0x10C9},	// 20003448
	{0x0F12, 0x8129},	// 2000344A
	{0x0F12, 0x8940},	// 2000344C
	{0x0F12, 0x2800},	// 2000344E
	{0x0F12, 0xD006},	// 20003450
	{0x0F12, 0x2001},	// 20003452
	{0x0F12, 0x0280},	// 20003454
	{0x0F12, 0x81A8},	// 20003456
	{0x0F12, 0x8168},	// 20003458
	{0x0F12, 0x8228},	// 2000345A
	{0x0F12, 0x81E8},	// 2000345C
	{0x0F12, 0xBDF8},	// 2000345E
	{0x0F12, 0x2001},	// 20003460
	{0x0F12, 0x81A0},	// 20003462
	{0x0F12, 0x4989},	// 20003464
	{0x0F12, 0x8048},	// 20003466
	{0x0F12, 0x8008},	// 20003468
	{0x0F12, 0x8BF8},	// 2000346A
	{0x0F12, 0xF000},	// 2000346C
	{0x0F12, 0xF93C},	// 2000346E
	{0x0F12, 0x8BF0},	// 20003470
	{0x0F12, 0x2800},	// 20003472
	{0x0F12, 0xD009},	// 20003474
	{0x0F12, 0x81A8},	// 20003476
	{0x0F12, 0x4884},	// 20003478
	{0x0F12, 0x3040},	// 2000347A
	{0x0F12, 0x8801},	// 2000347C
	{0x0F12, 0x8169},	// 2000347E
	{0x0F12, 0x8841},	// 20003480
	{0x0F12, 0x8229},	// 20003482
	{0x0F12, 0x8880},	// 20003484
	{0x0F12, 0x81E8},	// 20003486
	{0x0F12, 0xBDF8},	// 20003488
	{0x0F12, 0x2000},	// 2000348A
	{0x0F12, 0x81A0},	// 2000348C
	{0x0F12, 0x497F},	// 2000348E
	{0x0F12, 0x8048},	// 20003490
	{0x0F12, 0x2001},	// 20003492
	{0x0F12, 0x8008},	// 20003494
	{0x0F12, 0x8BF8},	// 20003496
	{0x0F12, 0xF000},	// 20003498
	{0x0F12, 0xF926},	// 2000349A
	{0x0F12, 0x8BF0},	// 2000349C
	{0x0F12, 0x2800},	// 2000349E
	{0x0F12, 0xD009},	// 200034A0
	{0x0F12, 0x81A8},	// 200034A2
	{0x0F12, 0x4879},	// 200034A4
	{0x0F12, 0x3040},	// 200034A6
	{0x0F12, 0x8801},	// 200034A8
	{0x0F12, 0x8169},	// 200034AA
	{0x0F12, 0x8841},	// 200034AC
	{0x0F12, 0x8229},	// 200034AE
	{0x0F12, 0x8880},	// 200034B0
	{0x0F12, 0x81E8},	// 200034B2
	{0x0F12, 0xBDF8},	// 200034B4
	{0x0F12, 0x2001},	// 200034B6
	{0x0F12, 0x0280},	// 200034B8
	{0x0F12, 0x81A8},	// 200034BA
	{0x0F12, 0x8168},	// 200034BC
	{0x0F12, 0x8228},	// 200034BE
	{0x0F12, 0x81E8},	// 200034C0
	{0x0F12, 0xBDF8},	// 200034C2
	{0x0F12, 0xB5F3},	// 200034C4
	{0x0F12, 0xB091},	// 200034C6
	{0x0F12, 0x4607},	// 200034C8
	{0x0F12, 0x2220},	// 200034CA
	{0x0F12, 0x4974},	// 200034CC
	{0x0F12, 0xA809},	// 200034CE
	{0x0F12, 0xF000},	// 200034D0
	{0x0F12, 0xF91C},	// 200034D2
	{0x0F12, 0x2220},	// 200034D4
	{0x0F12, 0x4972},	// 200034D6
	{0x0F12, 0x3120},	// 200034D8
	{0x0F12, 0xA801},	// 200034DA
	{0x0F12, 0xF000},	// 200034DC
	{0x0F12, 0xF916},	// 200034DE
	{0x0F12, 0x2400},	// 200034E0
	{0x0F12, 0x4E70},	// 200034E2
	{0x0F12, 0x00A0},	// 200034E4
	{0x0F12, 0xAA01},	// 200034E6
	{0x0F12, 0x5E11},	// 200034E8
	{0x0F12, 0x1883},	// 200034EA
	{0x0F12, 0x2202},	// 200034EC
	{0x0F12, 0x5E9A},	// 200034EE
	{0x0F12, 0x9B12},	// 200034F0
	{0x0F12, 0x4379},	// 200034F2
	{0x0F12, 0x435A},	// 200034F4
	{0x0F12, 0x1889},	// 200034F6
	{0x0F12, 0x17CA},	// 200034F8
	{0x0F12, 0x0E92},	// 200034FA
	{0x0F12, 0x1851},	// 200034FC
	{0x0F12, 0x1189},	// 200034FE
	{0x0F12, 0xAA09},	// 20003500
	{0x0F12, 0x5A13},	// 20003502
	{0x0F12, 0x199D},	// 20003504
	{0x0F12, 0x1880},	// 20003506
	{0x0F12, 0x8842},	// 20003508
	{0x0F12, 0x7828},	// 2000350A
	{0x0F12, 0x1840},	// 2000350C
	{0x0F12, 0x2100},	// 2000350E
	{0x0F12, 0xF000},	// 20003510
	{0x0F12, 0xF902},	// 20003512
	{0x0F12, 0x7028},	// 20003514
	{0x0F12, 0x1C64},	// 20003516
	{0x0F12, 0x2C08},	// 20003518
	{0x0F12, 0xD3E3},	// 2000351A
	{0x0F12, 0xB013},	// 2000351C
	{0x0F12, 0xBDF0},	// 2000351E
	{0x0F12, 0xB5F3},	// 20003520
	{0x0F12, 0xB081},	// 20003522
	{0x0F12, 0x4C58},	// 20003524
	{0x0F12, 0x4A60},	// 20003526
	{0x0F12, 0x1D24},	// 20003528
	{0x0F12, 0x6820},	// 2000352A
	{0x0F12, 0x2701},	// 2000352C
	{0x0F12, 0x0901},	// 2000352E
	{0x0F12, 0x0049},	// 20003530
	{0x0F12, 0x0705},	// 20003532
	{0x0F12, 0x5A53},	// 20003534
	{0x0F12, 0x0F2D},	// 20003536
	{0x0F12, 0x4638},	// 20003538
	{0x0F12, 0x40A8},	// 2000353A
	{0x0F12, 0x4383},	// 2000353C
	{0x0F12, 0x5253},	// 2000353E
	{0x0F12, 0x484B},	// 20003540
	{0x0F12, 0x78C0},	// 20003542
	{0x0F12, 0x2800},	// 20003544
	{0x0F12, 0xD032},	// 20003546
	{0x0F12, 0x4858},	// 20003548
	{0x0F12, 0x4D59},	// 2000354A
	{0x0F12, 0x8D81},	// 2000354C
	{0x0F12, 0x2900},	// 2000354E
	{0x0F12, 0xD025},	// 20003550
	{0x0F12, 0x88A0},	// 20003552
	{0x0F12, 0x2800},	// 20003554
	{0x0F12, 0xD122},	// 20003556
	{0x0F12, 0x4A54},	// 20003558
	{0x0F12, 0x6DA8},	// 2000355A
	{0x0F12, 0x8DD2},	// 2000355C
	{0x0F12, 0x0C03},	// 2000355E
	{0x0F12, 0xD006},	// 20003560
	{0x0F12, 0x0A03},	// 20003562
	{0x0F12, 0x4359},	// 20003564
	{0x0F12, 0x60A1},	// 20003566
	{0x0F12, 0x60E0},	// 20003568
	{0x0F12, 0x4353},	// 2000356A
	{0x0F12, 0x6123},	// 2000356C
	{0x0F12, 0xE006},	// 2000356E
	{0x0F12, 0x4341},	// 20003570
	{0x0F12, 0x0A09},	// 20003572
	{0x0F12, 0x60A1},	// 20003574
	{0x0F12, 0x60E0},	// 20003576
	{0x0F12, 0x4350},	// 20003578
	{0x0F12, 0x0A00},	// 2000357A
	{0x0F12, 0x6120},	// 2000357C
	{0x0F12, 0x6920},	// 2000357E
	{0x0F12, 0x65A8},	// 20003580
	{0x0F12, 0x4941},	// 20003582
	{0x0F12, 0x9801},	// 20003584
	{0x0F12, 0x3128},	// 20003586
	{0x0F12, 0xF000},	// 20003588
	{0x0F12, 0xF8CC},	// 2000358A
	{0x0F12, 0x4629},	// 2000358C
	{0x0F12, 0x3158},	// 2000358E
	{0x0F12, 0xC94E},	// 20003590
	{0x0F12, 0x483D},	// 20003592
	{0x0F12, 0x3018},	// 20003594
	{0x0F12, 0xC04E},	// 20003596
	{0x0F12, 0x68E0},	// 20003598
	{0x0F12, 0x65A8},	// 2000359A
	{0x0F12, 0x80A7},	// 2000359C
	{0x0F12, 0x88A0},	// 2000359E
	{0x0F12, 0x2802},	// 200035A0
	{0x0F12, 0xD106},	// 200035A2
	{0x0F12, 0x68A0},	// 200035A4
	{0x0F12, 0x65A8},	// 200035A6
	{0x0F12, 0x2003},	// 200035A8
	{0x0F12, 0x80A0},	// 200035AA
	{0x0F12, 0xE001},	// 200035AC
	{0x0F12, 0x2000},	// 200035AE
	{0x0F12, 0x80A0},	// 200035B0
	{0x0F12, 0x9902},	// 200035B2
	{0x0F12, 0x9801},	// 200035B4
	{0x0F12, 0xF000},	// 200035B6
	{0x0F12, 0xF8B5},	// 200035B8
	{0x0F12, 0x6820},	// 200035BA
	{0x0F12, 0x4B3A},	// 200035BC
	{0x0F12, 0x0901},	// 200035BE
	{0x0F12, 0x0049},	// 200035C0
	{0x0F12, 0x0704},	// 200035C2
	{0x0F12, 0x5A5A},	// 200035C4
	{0x0F12, 0x0F24},	// 200035C6
	{0x0F12, 0x4638},	// 200035C8
	{0x0F12, 0x40A0},	// 200035CA
	{0x0F12, 0x4302},	// 200035CC
	{0x0F12, 0x525A},	// 200035CE
	{0x0F12, 0xBDFE},	// 200035D0
	{0x0F12, 0xB570},	// 200035D2
	{0x0F12, 0x2001},	// 200035D4
	{0x0F12, 0xF000},	// 200035D6
	{0x0F12, 0xF8AB},	// 200035D8
	{0x0F12, 0x4C2B},	// 200035DA
	{0x0F12, 0x1D24},	// 200035DC
	{0x0F12, 0x88A0},	// 200035DE
	{0x0F12, 0x2801},	// 200035E0
	{0x0F12, 0xD10F},	// 200035E2
	{0x0F12, 0x4620},	// 200035E4
	{0x0F12, 0x3024},	// 200035E6
	{0x0F12, 0xF000},	// 200035E8
	{0x0F12, 0xF8A8},	// 200035EA
	{0x0F12, 0x1F21},	// 200035EC
	{0x0F12, 0x4830},	// 200035EE
	{0x0F12, 0x6A0D},	// 200035F0
	{0x0F12, 0x69CB},	// 200035F2
	{0x0F12, 0x698A},	// 200035F4
	{0x0F12, 0x6A49},	// 200035F6
	{0x0F12, 0x6605},	// 200035F8
	{0x0F12, 0x65C3},	// 200035FA
	{0x0F12, 0x6582},	// 200035FC
	{0x0F12, 0x6641},	// 200035FE
	{0x0F12, 0x2002},	// 20003600
	{0x0F12, 0x80A0},	// 20003602
	{0x0F12, 0x4929},	// 20003604
	{0x0F12, 0x8E08},	// 20003606
	{0x0F12, 0x1C40},	// 20003608
	{0x0F12, 0x8608},	// 2000360A
	{0x0F12, 0xBD70},	// 2000360C
	{0x0F12, 0xB570},	// 2000360E
	{0x0F12, 0x4604},	// 20003610
	{0x0F12, 0x4D28},	// 20003612
	{0x0F12, 0x7828},	// 20003614
	{0x0F12, 0x4320},	// 20003616
	{0x0F12, 0xD00C},	// 20003618
	{0x0F12, 0x20C1},	// 2000361A
	{0x0F12, 0x4622},	// 2000361C
	{0x0F12, 0x2101},	// 2000361E
	{0x0F12, 0x0200},	// 20003620
	{0x0F12, 0xF000},	// 20003622
	{0x0F12, 0xF891},	// 20003624
	{0x0F12, 0x2C00},	// 20003626
	{0x0F12, 0xD103},	// 20003628
	{0x0F12, 0x20FF},	// 2000362A
	{0x0F12, 0x4922},	// 2000362C
	{0x0F12, 0x3001},	// 2000362E
	{0x0F12, 0x8048},	// 20003630
	{0x0F12, 0x702C},	// 20003632
	{0x0F12, 0xBD70},	// 20003634
	{0x0F12, 0xB5F8},	// 20003636
	{0x0F12, 0x4605},	// 20003638
	{0x0F12, 0x460E},	// 2000363A
	{0x0F12, 0x4617},	// 2000363C
	{0x0F12, 0x461C},	// 2000363E
	{0x0F12, 0x480D},	// 20003640
	{0x0F12, 0x2181},	// 20003642
	{0x0F12, 0x3820},	// 20003644
	{0x0F12, 0x6980},	// 20003646
	{0x0F12, 0x5C09},	// 20003648
	{0x0F12, 0x0789},	// 2000364A
	{0x0F12, 0xD509},	// 2000364C
	{0x0F12, 0x3020},	// 2000364E
	{0x0F12, 0x7801},	// 20003650
	{0x0F12, 0x481A},	// 20003652
	{0x0F12, 0x8880},	// 20003654
	{0x0F12, 0xF000},	// 20003656
	{0x0F12, 0xF841},	// 20003658
	{0x0F12, 0x2802},	// 2000365A
	{0x0F12, 0xD900},	// 2000365C
	{0x0F12, 0x1E80},	// 2000365E
	{0x0F12, 0x1904},	// 20003660
	{0x0F12, 0x4817},	// 20003662
	{0x0F12, 0x8047},	// 20003664
	{0x0F12, 0x8084},	// 20003666
	{0x0F12, 0x80C5},	// 20003668
	{0x0F12, 0x8106},	// 2000366A
	{0x0F12, 0xBDF8},	// 2000366C
	{0x0F12, 0x0000},	// 2000366E
	{0x0F12, 0x2370},	// 20003670
	{0x0F12, 0x2000},	// 20003672
	{0x0F12, 0x01E4},	// 20003674
	{0x0F12, 0x2000},	// 20003676
	{0x0F12, 0x2EBC},	// 20003678
	{0x0F12, 0x2000},	// 2000367A
	{0x0F12, 0x0140},	// 2000367C
	{0x0F12, 0xD000},	// 2000367E
	{0x0F12, 0xB080},	// 20003680
	{0x0F12, 0xD000},	// 20003682
	{0x0F12, 0x12CC},	// 20003684
	{0x0F12, 0x2000},	// 20003686
	{0x0F12, 0x3798},	// 20003688
	{0x0F12, 0x2000},	// 2000368A
	{0x0F12, 0xA000},	// 2000368C
	{0x0F12, 0xD000},	// 2000368E
	{0x0F12, 0x0BB8},	// 20003690
	{0x0F12, 0x0000},	// 20003692
	{0x0F12, 0x0A10},	// 20003694
	{0x0F12, 0x2000},	// 20003696
	{0x0F12, 0x1224},	// 20003698
	{0x0F12, 0x2000},	// 2000369A
	{0x0F12, 0x2590},	// 2000369C
	{0x0F12, 0x2000},	// 2000369E
	{0x0F12, 0x3754},	// 200036A0
	{0x0F12, 0x2000},	// 200036A2
	{0x0F12, 0x2242},	// 200036A4
	{0x0F12, 0x2000},	// 200036A6
	{0x0F12, 0x1100},	// 200036A8
	{0x0F12, 0xD000},	// 200036AA
	{0x0F12, 0x2F34},	// 200036AC
	{0x0F12, 0x2000},	// 200036AE
	{0x0F12, 0x2138},	// 200036B0
	{0x0F12, 0x2000},	// 200036B2
	{0x0F12, 0x256A},	// 200036B4
	{0x0F12, 0x2000},	// 200036B6
	{0x0F12, 0xC100},	// 200036B8
	{0x0F12, 0xD000},	// 200036BA
	{0x0F12, 0x0D98},	// 200036BC
	{0x0F12, 0x2000},	// 200036BE
	{0x0F12, 0x3200},	// 200036C0
	{0x0F12, 0xD000},	// 200036C2
	{0x0F12, 0xB403},	// 200036C4
	{0x0F12, 0x4801},	// 200036C6
	{0x0F12, 0x9001},	// 200036C8
	{0x0F12, 0xBD01},	// 200036CA
	{0x0F12, 0x0895},	// 200036CC
	{0x0F12, 0x0001},	// 200036CE
	{0x0F12, 0xB403},	// 200036D0
	{0x0F12, 0x4801},	// 200036D2
	{0x0F12, 0x9001},	// 200036D4
	{0x0F12, 0xBD01},	// 200036D6
	{0x0F12, 0x092B},	// 200036D8
	{0x0F12, 0x0001},	// 200036DA
	{0x0F12, 0xB403},	// 200036DC
	{0x0F12, 0x4801},	// 200036DE
	{0x0F12, 0x9001},	// 200036E0
	{0x0F12, 0xBD01},	// 200036E2
	{0x0F12, 0x0DF1},	// 200036E4
	{0x0F12, 0x0001},	// 200036E6
	{0x0F12, 0xB403},	// 200036E8
	{0x0F12, 0x4801},	// 200036EA
	{0x0F12, 0x9001},	// 200036EC
	{0x0F12, 0xBD01},	// 200036EE
	{0x0F12, 0xFCBF},	// 200036F0
	{0x0F12, 0x0000},	// 200036F2
	{0x0F12, 0xB403},	// 200036F4
	{0x0F12, 0x4801},	// 200036F6
	{0x0F12, 0x9001},	// 200036F8
	{0x0F12, 0xBD01},	// 200036FA
	{0x0F12, 0x0895},	// 200036FC
	{0x0F12, 0x0000},	// 200036FE
	{0x0F12, 0xB403},	// 20003700
	{0x0F12, 0x4801},	// 20003702
	{0x0F12, 0x9001},	// 20003704
	{0x0F12, 0xBD01},	// 20003706
	{0x0F12, 0xFC2D},	// 20003708
	{0x0F12, 0x0000},	// 2000370A
	{0x0F12, 0xB403},	// 2000370C
	{0x0F12, 0x4801},	// 2000370E
	{0x0F12, 0x9001},	// 20003710
	{0x0F12, 0xBD01},	// 20003712
	{0x0F12, 0x0371},	// 20003714
	{0x0F12, 0x0000},	// 20003716
	{0x0F12, 0xB403},	// 20003718
	{0x0F12, 0x4801},	// 2000371A
	{0x0F12, 0x9001},	// 2000371C
	{0x0F12, 0xBD01},	// 2000371E
	{0x0F12, 0x9F27},	// 20003720
	{0x0F12, 0x0000},	// 20003722
	{0x0F12, 0xB403},	// 20003724
	{0x0F12, 0x4801},	// 20003726
	{0x0F12, 0x9001},	// 20003728
	{0x0F12, 0xBD01},	// 2000372A
	{0x0F12, 0x745B},	// 2000372C
	{0x0F12, 0x0000},	// 2000372E
	{0x0F12, 0xB403},	// 20003730
	{0x0F12, 0x4801},	// 20003732
	{0x0F12, 0x9001},	// 20003734
	{0x0F12, 0xBD01},	// 20003736
	{0x0F12, 0x990D},	// 20003738
	{0x0F12, 0x0000},	// 2000373A
	{0x0F12, 0xB403},	// 2000373C
	{0x0F12, 0x4801},	// 2000373E
	{0x0F12, 0x9001},	// 20003740
	{0x0F12, 0xBD01},	// 20003742
	{0x0F12, 0x7447},	// 20003744
	{0x0F12, 0x0000},	// 20003746
	{0x0F12, 0xB403},	// 20003748
	{0x0F12, 0x4801},	// 2000374A
	{0x0F12, 0x9001},	// 2000374C
	{0x0F12, 0xBD01},	// 2000374E
	{0x0F12, 0xA1DD},	// 20003750
	{0x0F12, 0x0000},	// 20003752
	{0x0F12, 0x0083},	// 20003754
	{0x0F12, 0x00FF},	// 20003756
	{0x0F12, 0x0084},	// 20003758
	{0x0F12, 0x00FF},	// 2000375A
	{0x0F12, 0x0038},	// 2000375C
	{0x0F12, 0x007F},	// 2000375E
	{0x0F12, 0x0039},	// 20003760
	{0x0F12, 0x007F},	// 20003762
	{0x0F12, 0x003A},	// 20003764
	{0x0F12, 0x007F},	// 20003766
	{0x0F12, 0x003B},	// 20003768
	{0x0F12, 0x007F},	// 2000376A
	{0x0F12, 0x003C},	// 2000376C
	{0x0F12, 0x0007},	// 2000376E
	{0x0F12, 0x003D},	// 20003770
	{0x0F12, 0x0007},	// 20003772
	{0x0F12, 0x0080},	// 20003774
	{0x0F12, 0x0000},	// 20003776
	{0x0F12, 0x0080},	// 20003778
	{0x0F12, 0x0000},	// 2000377A
	{0x0F12, 0xFFC0},	// 2000377C
	{0x0F12, 0x0000},	// 2000377E
	{0x0F12, 0xFFC0},	// 20003780
	{0x0F12, 0x0000},	// 20003782
	{0x0F12, 0xFFC0},	// 20003784
	{0x0F12, 0x0000},	// 20003786
	{0x0F12, 0xFFC0},	// 20003788
	{0x0F12, 0x0000},	// 2000378A
	{0x0F12, 0xFFFC},	// 2000378C
	{0x0F12, 0x0000},	// 2000378E
	{0x0F12, 0xFFFC},	// 20003790
	{0x0F12, 0x0000},	// 20003792
	{0x0F12, 0x007F},	// 20003794
	{0x0F12, 0x0000},	// 20003796

   // End of Patch Data(Last : 20003796h)
   // Total Size 1460 (0x05B4)
   // Addr : 31E4 , Size : 1458(5B2h)

   // TNP_WAKEUP_MIPI2LANE_ULPS
   // TNP_GAS_OTP_PAGE_SELECT
   // TNP_AWB_MODUL_COMP
   // TNP_USER_SHARP_BLUR
   // TNP_AE_HDR_CONTROL
   // TNP_FLS_FRAME_SKIP_FIX
   // TNP_EOL_WA_2ND_VER
	{0x0028, 0x2000},
	{0x002A, 0x122C},
	{0x0F12, 0x0000},
	{0x002A, 0x0A32},
	{0x0F12, 0x0001},
	{0x002A, 0x0A2C},
	{0x0F12, 0x0002},
	{0x002A, 0x0A2E},
	{0x0F12, 0x0100},

	{0x0028, 0xD000},
	{0x002A, 0x1000},
	{0x0F12, 0x0001},

//======================================================
// 03.Analog Setting & ASP Control
//======================================================
//This register is for FACTORY ONLY.
//If you change it without prior notification
//YOU are RESPONSIBLE for the FAILURE that will happen in the future
//WARNING : Before REG_TC_IPRM_InitParamsUpdated, Do not Write at HW Registers directly.
//if Fw has Register's value, it will be updated by FW default.
//Move to 20-1.HW Direct Setting due to Timing constraint.

	{0x002A, 0xF400},
	{0x0F12, 0x443F},
	{0x0F12, 0x2020},
	{0x0F12, 0x0B0D},
	{0x0F12, 0x8008},
	{0x0F12, 0x0003},
	{0x0F12, 0x0010},
	{0x002A, 0xF410},
	{0x0F12, 0x5777},
	{0x002A, 0xF414},
	{0x0F12, 0x0007},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},

	{0x002A, 0xF41E},  //Add patch ,andy
	{0x0F12, 0x1111},

	{0x002A, 0xF424},
	{0x0F12, 0x5300},
	{0x0F12, 0x0209},
	{0x0F12, 0x1037},
	{0x0F12, 0x0007},
	{0x0F12, 0x0081},
	{0x002A, 0xF432},
	{0x0F12, 0x0508},
	{0x0F12, 0x0509},
	{0x0F12, 0x08F9},	//VPIX 80F9
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x1002},
	{0x002A, 0xF5B8},
	{0x0F12, 0x0010},
	{0x0F12, 0x0020},
	{0x0F12, 0x0040},
	{0x0F12, 0x0050},
	{0x0F12, 0x0070},
	{0x0F12, 0x0080},
	{0x0F12, 0x00A0},
	{0x0F12, 0x00B0},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x002F},
	{0x0F12, 0x005F},
	{0x0F12, 0x005F},
	{0x0F12, 0x008F},
	{0x0F12, 0x008F},
	{0x0F12, 0x00BE},
	{0x002A, 0xE502},
	{0x0F12, 0x0820},	// bpr_ob
	{0x0F12, 0x0000},	// bpr_active
	{0x002A, 0xE600},
	{0x0F12, 0x0010},	// adlc_config
	{0x002A, 0xE606},
	{0x0F12, 0x0125},	// adlc_enable
	{0x002A, 0xE602},
	{0x0F12, 0x0040},	// adlc_data_pedestal
	{0x0F12, 0x1FC0},	// adlc_data_depedestal off
	{0x002A, 0xE61E},
	{0x0F12, 0x0000},	// ptune_gain_total
	{0x002A, 0xE628},
	{0x0F12, 0x0000},	// ptune_offset_total
	{0x002A, 0xE614},
	{0x0F12, 0x2010},	// adlc_fadlc_filter_co
	{0x002A, 0xE62E},
	{0x0F12, 0x0007},	// adlc_fadlc_filter_config
	{0x0F12, 0x0000},	// adlc_refresh_level_diff_threshold

   // Start of Analog setting
   // revision history
   // 2012.6. 4 1st draft
   // 2012.6.19 Modified the ADC SAT
   // MS off
	{0x002A, 0xF482},
	{0x0F12, 0x0613},
	{0x0F12, 0x0010},
	{0x0F12, 0x0613},
	{0x002A, 0xF48A},
	{0x0F12, 0x0615},
	{0x002A, 0xF48E},
	{0x0F12, 0x0617},
	{0x0F12, 0x0205},
	{0x0F12, 0x0258},
	{0x0F12, 0x000F},
	{0x0F12, 0x0617},
	{0x0F12, 0x0204},
	{0x0F12, 0x0615},
	{0x0F12, 0x0205},
	{0x0F12, 0x0613},
	{0x0F12, 0x0204},
	{0x0F12, 0x0278},
	{0x0F12, 0x0206},
	{0x0F12, 0x02BE},
	{0x002A, 0xF4AA},
	{0x0F12, 0x00AF},
	{0x002A, 0xF4AE},
	{0x0F12, 0x00BE},
	{0x002A, 0xF4B2},
	{0x0F12, 0x00C1},
	{0x002A, 0xF4B6},
	{0x0F12, 0x0204},
	{0x0F12, 0x0258},
	{0x0F12, 0x0273},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x00C0},
	{0x002A, 0xF5F4},
	{0x0F12, 0x00C1},
	{0x002A, 0xF4CA},
	{0x0F12, 0x0615},
	{0x002A, 0xF4CE},
	{0x0F12, 0x0104},
	{0x0F12, 0x0204},
	{0x0F12, 0x0301},
	{0x0F12, 0x0611},
	{0x0F12, 0x0206},
	{0x0F12, 0x021E},
	{0x0F12, 0x020E},
	{0x0F12, 0x0226},
	{0x0F12, 0x0216},
	{0x0F12, 0x0226},
	{0x0F12, 0x0206},
	{0x0F12, 0x0208},
	{0x002A, 0xF4EA},
	{0x0F12, 0x020E},
	{0x0F12, 0x0226},
	{0x002A, 0xF4F2},
	{0x0F12, 0x0206},
	{0x0F12, 0x0208},
	{0x0F12, 0x0104},
	{0x0F12, 0x0175},
	{0x0F12, 0x0185},
	{0x0F12, 0x0204},
	{0x002A, 0xF500},
	{0x0F12, 0x0301},
	{0x0F12, 0x047A},
	{0x0F12, 0x048A},
	{0x0F12, 0x0611},
	{0x0F12, 0x0176},
	{0x0F12, 0x017D},
	{0x0F12, 0x020A},
	{0x0F12, 0x0212},
	{0x0F12, 0x021F},
	{0x0F12, 0x0227},
	{0x0F12, 0x047B},
	{0x0F12, 0x0482},
	{0x0F12, 0x0615},
	{0x0F12, 0x061D},
	{0x0F12, 0x0178},
	{0x0F12, 0x017E},
	{0x0F12, 0x020C},
	{0x0F12, 0x0213},
	{0x0F12, 0x0221},
	{0x0F12, 0x0228},
	{0x0F12, 0x047D},
	{0x0F12, 0x0483},
	{0x0F12, 0x0617},
	{0x0F12, 0x061E},
	{0x0F12, 0x0179},
	{0x0F12, 0x017E},
	{0x0F12, 0x020D},
	{0x0F12, 0x0213},
	{0x0F12, 0x0222},
	{0x0F12, 0x0228},
	{0x0F12, 0x047E},
	{0x0F12, 0x0483},
	{0x0F12, 0x0618},
	{0x0F12, 0x061E},
	{0x0F12, 0x0176},
	{0x0F12, 0x0178},
	{0x0F12, 0x0206},
	{0x0F12, 0x0208},
	{0x0F12, 0x021D},
	{0x0F12, 0x021F},
	{0x0F12, 0x047B},
	{0x0F12, 0x047D},
	{0x0F12, 0x0613},
	{0x0F12, 0x0615},
	{0x002A, 0xF55C},
	{0x0F12, 0x017C},
	{0x0F12, 0x017F},
	{0x0F12, 0x020C},
	{0x0F12, 0x0211},
	{0x0F12, 0x0223},
	{0x0F12, 0x0228},
	{0x0F12, 0x0481},
	{0x0F12, 0x0484},
	{0x0F12, 0x0619},
	{0x0F12, 0x061E},
	{0x002A, 0xF574},
	{0x0F12, 0x0176},
	{0x0F12, 0x0178},
	{0x0F12, 0x0206},
	{0x0F12, 0x0208},
	{0x0F12, 0x021D},
	{0x0F12, 0x021F},
	{0x0F12, 0x047B},
	{0x0F12, 0x047D},
	{0x0F12, 0x0613},
	{0x0F12, 0x0615},
	{0x002A, 0xF58A},
	{0x0F12, 0x017C},
	{0x0F12, 0x020C},
	{0x0F12, 0x0481},
	{0x0F12, 0x0619},
	{0x0F12, 0x0103},
	{0x0F12, 0x0205},
	{0x0F12, 0x0300},
	{0x0F12, 0x0612},
	{0x002A, 0xF59E},
	{0x0F12, 0x0A6B},
	{0x002A, 0xF5FA},
	{0x0F12, 0x0206},
	{0x0F12, 0x0208},
	{0x002A, 0xF456},
	{0x0F12, 0x0206},
	{0x0F12, 0x0222},
	{0x002A, 0xF5A2},
	{0x0F12, 0x00C0},
	{0x0F12, 0x0617},
	{0x0F12, 0x00C1},
	{0x0F12, 0x00C3},
	{0x0F12, 0x0206},
	{0x0F12, 0x0209},
	{0x0F12, 0x0613},
	{0x0F12, 0x0616},
	{0x0F12, 0x0209},
	{0x0F12, 0x0A60},
	{0x0F12, 0x0A70},

 // additional option
	{0x002A, 0xC342},
	{0x0F12, 0x0A72},
	{0x002A, 0xC200},
	{0x0F12, 0x0A17},
	{0x002A, 0xE300},
	{0x0F12, 0x0007},
	{0x002A, 0xF430},
	{0x0F12, 0x0E10},
	{0x002A, 0xC202},
	{0x0F12, 0x0400},
	{0x002A, 0xF422},
	{0x0F12, 0x000E},
	{0x002A, 0xF2AA},
	{0x0F12, 0x0100},
	{0x002A, 0xF40E},
	{0x0F12, 0x0071},
	{0x002A, 0xF42E},
	{0x0F12, 0x00A6},
	{0x002A, 0xF412},
	{0x0F12, 0x00C8},
	{0x002A, 0xF420},
	{0x0F12, 0x1000},
	{0x002A, 0xF40C},
	{0x0F12, 0x0700},
   // End of Analog setting

   //For subsampling Size
   // For Capture
   //ETC
	{0x002A, 0x0054},
	{0x0F12, 0x002D},
   //Forbidden
   //WRITE #senHal_shutAreaStart_1_   FC44
   //WRITE #senHal_sRightFobiddenStart_1_ 0BB8

   //Start Offset
	{0x0028, 0x2000},
	{0x002A, 0x0D04},
	{0x0F12, 0x0044},
	{0x0F12, 0x0034},
   //Line length pck
	{0x0F12, 0x0072}, //Full mode: adding line line_length_pck 2608
	{0x0F12, 0x082A}, //	 //Bin mode: min line_length_pck 2090 //

	{0x002A, 0x0CF8},
	{0x0F12, 0x0001},//0:sub sampling, 1: average subsampling

   //SHBN Comp_bias control
	{0x002A, 0x0D9E},
	{0x0F12, 0x0040}, //gain > x2, use Tune2 register
	{0x0F12, 0x0000}, //comp1_bias=0d
	{0x0F12, 0x0007}, //comp1_bias=7d


   //======================================================
   //04.ETC Setting
   //======================================================
   //WRITE #oif_bBypassMipiSleepSeq 1  //for non ulps mode
	{0x002A, 0x09DE},
	{0x0F12, 0x0000},
	{0x002A, 0x09E4},
	{0x0F12, 0xF400},
	{0x0F12, 0x005A},
	{0x0F12, 0xF5B8},
	{0x0F12, 0x0078},
	{0x0F12, 0xE502},
	{0x0F12, 0x0004},
	{0x0F12, 0xE600},
	{0x0F12, 0x003E},
	{0x0F12, 0xF482},
	{0x0F12, 0x013C},
	{0x0F12, 0xE300},
	{0x0F12, 0x0002},
	{0x0F12, 0xF5F4},
	{0x0F12, 0x0002},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},


	//=====================================================
	//Gas_Anti Shading_Otp.no OTP)
	//=====================================================
	{0x002A, 0x14AC},
	{0x0F12, 0x0001},		  //#ash_bUseGasAlpha
	{0x002A, 0x149C},
	{0x0F12, 0x0001},		  //#ash_bUseAutoStart
	{0x002A, 0x1498},
	{0x0F12, 0x0001},		  //#ash_bUseGainCal
	{0x002A, 0x149E},
	{0x0F12, 0x0001},		  //#ash_bWriteEdgemode

//WRITE	 #skl_OTP_usWaitTime	0100		 // This register should be positioned in fornt of D0001000
//WRITE	 #skl_bUseOTPfunc		0001		 // This is OTP on/off function
//WRITE	 #ash_bUseOTPData		0000		 //
//WRITE	 #awbb_otp_disable		0001		 //
//WRITE	 #ash_bUseGasAlphaOTP	0000		 //

	{0x002A, 0x1478},
	{0x0F12, 0x0001},		  //wbt_bUseOutdoorASH

// Refer Mon_AWB_RotGain
	{0x002A, 0x1480},
	{0x0F12, 0x00C0},
	{0x0F12, 0x00D0},
	{0x0F12, 0x00F0},
	{0x0F12, 0x0100},
	{0x0F12, 0x0130},
	{0x0F12, 0x0160},
	{0x0F12, 0x01FF},

// GAS Alpha Table
	{0x002A, 0x14AE},
	{0x0F12, 0x4300},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x3C00},

	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},

	{0x0F12, 0x3F00},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},

	{0x0F12, 0x3300},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},

	{0x0F12, 0x3400},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},

	{0x0F12, 0x3900},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},

	{0x0F12, 0x3900},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},
	{0x0F12, 0x4000},


// Outdoor GAS Alpha
	{0x0F12, 0x4000}, // R   //by 7500K
	{0x0F12, 0x4000}, // GR
	{0x0F12, 0x4000}, // GB
	{0x0F12, 0x4000}, // B

// TVAR_ash_pGAS_high
	{0x002A, 0x1860},
// TVAR_ash_pGAS_high
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0101},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0001},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},
	{0x0F12, 0x0001},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0100},
	{0x0F12, 0x0001},
	{0x0F12, 0x0100},
	{0x0F12, 0x0001},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0100},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0101},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},


	// TVAR_ash_pGAS_low
	{0x0F12, 0x3F86},
	{0x0F12, 0xF8F4},
	{0x0F12, 0x0217},
	{0x0F12, 0xFFC0},
	{0x0F12, 0x0667},
	{0x0F12, 0xF895},
	{0x0F12, 0xF599},
	{0x0F12, 0xF5C1},
	{0x0F12, 0x05D0},
	{0x0F12, 0xFF7E},
	{0x0F12, 0xFBBD},
	{0x0F12, 0x0727},
	{0x0F12, 0xFB32},
	{0x0F12, 0x0BF2},
	{0x0F12, 0xFE1C},
	{0x0F12, 0xFB8D},
	{0x0F12, 0x02EC},
	{0x0F12, 0xFB4D},
	{0x0F12, 0x0F40},
	{0x0F12, 0xF6C4},
	{0x0F12, 0x035D},
	{0x0F12, 0x0025},
	{0x0F12, 0x0181},
	{0x0F12, 0x0371},
	{0x0F12, 0xFCA7},
	{0x0F12, 0xFD49},
	{0x0F12, 0xFAEE},
	{0x0F12, 0x0820},
	{0x0F12, 0xFACF},
	{0x0F12, 0xFEC5},
	{0x0F12, 0xF90B},
	{0x0F12, 0x0CB0},
	{0x0F12, 0xFD46},
	{0x0F12, 0xFD4B},
	{0x0F12, 0x0399},
	{0x0F12, 0xFB75},
	{0x0F12, 0x4C27},
	{0x0F12, 0xF6D5},
	{0x0F12, 0x0130},
	{0x0F12, 0x0342},
	{0x0F12, 0x0458},
	{0x0F12, 0xF8C2},
	{0x0F12, 0xF142},
	{0x0F12, 0xED0A},
	{0x0F12, 0x0F36},
	{0x0F12, 0xF6BE},
	{0x0F12, 0x0283},
	{0x0F12, 0x051F},
	{0x0F12, 0xF945},
	{0x0F12, 0x1A61},
	{0x0F12, 0xF1D0},
	{0x0F12, 0x039B},
	{0x0F12, 0xFADB},
	{0x0F12, 0x0012},
	{0x0F12, 0x1236},
	{0x0F12, 0xEAA6},
	{0x0F12, 0x09B8},
	{0x0F12, 0x0562},
	{0x0F12, 0xFB11},
	{0x0F12, 0x0549},
	{0x0F12, 0x03D2},
	{0x0F12, 0xFC02},
	{0x0F12, 0xFE3C},
	{0x0F12, 0xFC19},
	{0x0F12, 0x079B},
	{0x0F12, 0xFA7C},
	{0x0F12, 0xEE81},
	{0x0F12, 0x16B0},
	{0x0F12, 0xF775},
	{0x0F12, 0x0021},
	{0x0F12, 0x047D},
	{0x0F12, 0xF758},
	{0x0F12, 0x39FA},
	{0x0F12, 0xFB4B},
	{0x0F12, 0x003C},
	{0x0F12, 0x024D},
	{0x0F12, 0x0234},
	{0x0F12, 0xFBB1},
	{0x0F12, 0xF74D},
	{0x0F12, 0xF6EC},
	{0x0F12, 0x050E},
	{0x0F12, 0xFEA4},
	{0x0F12, 0xFFCC},
	{0x0F12, 0x02AC},
	{0x0F12, 0xFC9E},
	{0x0F12, 0x09DC},
	{0x0F12, 0xFD15},
	{0x0F12, 0xFFEE},
	{0x0F12, 0xFAEB},
	{0x0F12, 0x02F5},
	{0x0F12, 0x0AEF},
	{0x0F12, 0xF923},
	{0x0F12, 0x0466},
	{0x0F12, 0xFFDA},
	{0x0F12, 0x018E},
	{0x0F12, 0x0062},
	{0x0F12, 0x0071},
	{0x0F12, 0xFD61},
	{0x0F12, 0xF914},
	{0x0F12, 0x032F},
	{0x0F12, 0x047A},
	{0x0F12, 0xFBF2},
	{0x0F12, 0xF768},
	{0x0F12, 0x0A4E},
	{0x0F12, 0x00DB},
	{0x0F12, 0xFEC6},
	{0x0F12, 0xFE87},
	{0x0F12, 0xFC63},
	{0x0F12, 0x4044},
	{0x0F12, 0xF818},
	{0x0F12, 0x03DF},
	{0x0F12, 0xFD67},
	{0x0F12, 0x07DD},
	{0x0F12, 0xF86C},
	{0x0F12, 0xF5AC},
	{0x0F12, 0xF5C2},
	{0x0F12, 0x0553},
	{0x0F12, 0xFFB5},
	{0x0F12, 0xFD73},
	{0x0F12, 0x04E0},
	{0x0F12, 0xF9D9},
	{0x0F12, 0x0D3B},
	{0x0F12, 0xFDAD},
	{0x0F12, 0xFBCE},
	{0x0F12, 0xFFE7},
	{0x0F12, 0xFF3B},
	{0x0F12, 0x109A},
	{0x0F12, 0xF4B9},
	{0x0F12, 0x031C},
	{0x0F12, 0x03A8},
	{0x0F12, 0x006E},
	{0x0F12, 0x00CB},
	{0x0F12, 0xFD46},
	{0x0F12, 0xFE59},
	{0x0F12, 0xFD03},
	{0x0F12, 0x00FC},
	{0x0F12, 0xFF14},
	{0x0F12, 0x00C7},
	{0x0F12, 0xF760},
	{0x0F12, 0x0D5A},
	{0x0F12, 0xFA18},
	{0x0F12, 0x0427},
	{0x0F12, 0xFF0E},
	{0x0F12, 0xFABD},

//WRITE #ash_bGasBypass 1

//========================================================
// 06.AF Setting
//========================================================
	{0x002A, 0x01E8},
	{0x0F12, 0x0000},		  //REG_TC_IPRM_LedGpio
	{0x0F12, 0x0003},		  //REG_TC_IPRM_CM_Init_AfModeType
	{0x0F12, 0x0000},		  //REG_TC_IPRM_CM_Init_PwmConfig1
	{0x002A, 0x01F0},
	{0x0F12, 0x0000},		  //REG_TC_IPRM_CM_Init_GpioConfig1
	{0x002A, 0x01F8},
	{0x0F12, 0x000C},		 //REG_TC_IPRM_CM_Init_Mi2cBits [Data:Clock:ID] GPIO 1,2
	{0x002A, 0x01FC},
	{0x0F12, 0x0064},		  //REG_TC_IPRM_CM_Init_Mi2cRateKhz IIC Speed 100Khz
	{0x002A, 0x02D0},
	{0x0F12, 0x0100},		  //REG_TC_AF_FstWinStartX
	{0x0F12, 0x00E3},		  //REG_TC_AF_FstWinStartY
	{0x0F12, 0x0200},		  //REG_TC_AF_FstWinSizeX
	{0x0F12, 0x0238},		  //REG_TC_AF_FstWinSizeY
	{0x0F12, 0x01C6},		 //REG_TC_AF_ScndWinStartX
	{0x0F12, 0x0166},		  //REG_TC_AF_ScndWinStartY
	{0x0F12, 0x0074},		  //REG_TC_AF_ScndWinSizeX
	{0x0F12, 0x0132},		  //REG_TC_AF_ScndWinSizeY
	{0x0F12, 0x0001},		  //REG_TC_AF_WinSizesUpdated
	{0x002A, 0x0A1A},
	{0x0F12, 0x00FF}, //skl_af_StatOvlpExpFactor
	{0x002A, 0x0A2A},
	{0x0F12, 0x0000},		  //skl_af_bAfStatOff
	{0x002A, 0x0660},
	{0x0F12, 0x0000},		  //af_search_usAeStable
	{0x002A, 0x066C},
	{0x0F12, 0x1000},		  //af_search_usSingleAfFlags,  Double peak , Fine search enable,
	{0x002A, 0x0676},
	{0x0F12, 0x0002},		  //af_search_usFinePeakCount
	{0x0F12, 0x0000},		  //af_search_usFineMaxScale
	{0x002A, 0x0670},
	{0x0F12, 0x0003},		  //af_search_usMinPeakSamples
	{0x002A, 0x0662},
	{0x0F12, 0x00E5},		  //af_search_usPeakThr,  Full search (E5 90%)
	{0x0F12, 0x0098},		  //af_search_usPeakThrLow
	{0x002A, 0x06BE},
	{0x0F12, 0xFF95}, //af_search_usConfCheckOrder_1_
	{0x002A, 0x068E},
	{0x0F12, 0x0280},		  //af_search_usConfThr_4_
	{0x002A, 0x069A},
	{0x0F12, 0x03A0},		 //af_search_usConfThr_10_
	{0x0F12, 0x0320},		  //af_search_usConfThr_11_
	{0x002A, 0x06E0},
	{0x0F12, 0x0030},		  //af_stat_usMinStatVal
	{0x002A, 0x0710},
	{0x0F12, 0x0060},		  //af_scene_usSceneLowNormBrThr
	{0x002A, 0x06F8},
	{0x0F12, 0x0010},		  //af_stat_usBpfThresh
	{0x002A, 0x067A},
	{0x0F12, 0x0000},		  //af_search_usCapturePolicy
	{0x002A, 0x05D4},
	{0x0F12, 0x0086},		  //af_pos_usCaptureFixedPos
	{0x002A, 0x05B8},
	{0x0F12, 0x0080},		  //af_pos_usHomePos
	{0x002A, 0x05BC},
	{0x0F12, 0x0080},		  //af_pos_usLowConfPos Macro: 372
	{0x002A, 0x05BE},
	{0x0F12, 0x0174},  //af_pos_usLowConfPos Macro: 372
	{0x002A, 0x05C0},
	{0x0F12, 0x0120},		  //af_pos_usMiddlePos
	{0x002A, 0x05C2},
	{0x0F12, 0x0120},
#if 0
	{0x002A, 0x05D8},
	{0x0F12, 0x0014}, //af_pos_usTableLastInd
	{0x0F12, 0x0086}, //af_pos_usTable_0_
	{0x0F12, 0x0094},  //af_pos_usTable_1_
	{0x0F12, 0x00A2}, //af_pos_usTable_2_
	{0x0F12, 0x00B0}, //af_pos_usTable_3_
	{0x0F12, 0x00BE}, //af_pos_usTable_4_
	{0x0F12, 0x00CC}, //af_pos_usTable_5_
	{0x0F12, 0x00DA}, //af_pos_usTable_6_
	{0x0F12, 0x00E8}, //af_pos_usTable_7_
	{0x0F12, 0x00F6}, //af_pos_usTable_8_
	{0x0F12, 0x0104}, //af_pos_usTable_9_
	{0x0F12, 0x0112}, //af_pos_usTable_10_
	{0x0F12, 0x0120}, //af_pos_usTable_11_
	{0x0F12, 0x012E}, //af_pos_usTable_12_
	{0x0F12, 0x013C}, //af_pos_usTable_13_
	{0x0F12, 0x014A}, //af_pos_usTable_14_
	{0x0F12, 0x0158}, //af_pos_usTable_15_
	{0x0F12, 0x0166}, //af_pos_usTable_16_
	{0x0F12, 0x0174}, //af_pos_usTable_17_
	{0x0F12, 0x0182}, //af_pos_usTable_18_
	{0x0F12, 0x0190}, //af_pos_usTable_19_
	{0x0F12, 0x019A}, //af_pos_usTable_20_

	{0x002A, 0x071E},
	{0x0F12, 0x0018},
	{0x002A, 0x0750},
	{0x0F12, 0x0006},

// Continuous AF
	{0x002A, 0x071A},
	{0x0F12, 0x5050},//af_refocus_usFlUpLow	  //5050
	{0x0F12, 0x8080},//af_refocus_usFlLcUpLow  //8080
#else
	{0x002A, 0x05D8},
	{0x0F12, 0x0014}, //af_pos_usTableLastInd
	{0x0F12, 0x0032}, //af_pos_usTable_0_
	{0x0F12, 0x0047},  //af_pos_usTable_1_
	{0x0F12, 0x005C}, //af_pos_usTable_2_
	{0x0F12, 0x0071}, //af_pos_usTable_3_
	{0x0F12, 0x0086}, //af_pos_usTable_4_
	{0x0F12, 0x009B}, //af_pos_usTable_5_
	{0x0F12, 0x00B0}, //af_pos_usTable_6_
	{0x0F12, 0x00C5}, //af_pos_usTable_7_
	{0x0F12, 0x00DA}, //af_pos_usTable_8_
	{0x0F12, 0x00EF}, //af_pos_usTable_9_
	{0x0F12, 0x0104}, //af_pos_usTable_10_
	{0x0F12, 0x0119}, //af_pos_usTable_11_
	{0x0F12, 0x012E}, //af_pos_usTable_12_
	{0x0F12, 0x0143}, //af_pos_usTable_13_
	{0x0F12, 0x0158}, //af_pos_usTable_14_
	{0x0F12, 0x016D}, //af_pos_usTable_15_
	{0x0F12, 0x0182}, //af_pos_usTable_16_
	{0x0F12, 0x0197}, //af_pos_usTable_17_
	{0x0F12, 0x01AC}, //af_pos_usTable_18_
	{0x0F12, 0x01C1}, //af_pos_usTable_19_
	{0x0F12, 0x01CF}, //af_pos_usTable_20_

	{0x002A, 0x071E},
	{0x0F12, 0x0008},
	{0x002A, 0x0750},
	{0x0F12, 0x0002},

// Continuous AF
	{0x002A, 0x071A},
	{0x0F12, 0x3030},//af_refocus_usFlUpLow	  //5050
	{0x0F12, 0x3030},//af_refocus_usFlLcUpLow  //8080
#endif
// Scene Change Detection Sensitivity
//WRITE	 #af_scd_usResetNWaitFr		000A		 // x4 frames. (40 frames. This value should be same as af_refocus_usFlFrames)

	{0x002A, 0x0730},
	{0x0F12, 0x0000},
	{0x002A, 0x0736},
	{0x0F12, 0x0000},

// 0 ~ 0x400. Bigger value is more sensitivity.
	{0x002A, 0x0752},
	{0x0F12, 0x03E0}, //Sensitivity for Normal scene
	{0x0F12, 0x03C0}, //Sensitivity for Low light scene
	{0x0F12, 0x03E0}, //Sensitivity forOutdoor scene

// AF driver
	{0x002A, 0x056A},
	{0x0F12, 0x8000}, //	 power down flag.[15] bit set 1.
	{0x0F12, 0x0004}, //  Shift
	{0x0F12, 0x3FF0}, //  Mask

	{0x002A, 0x0574},
	{0x0F12, 0x0020},		  //  Slow motion delay
	{0x0F12, 0x0030},		  //  Moving distance threshold for Slow motion delay
	{0x0F12, 0x0010},		  //  Signal shaping delay time
	{0x0F12, 0x0040},		  //
	{0x0F12, 0x0080},		  //
	{0x0F12, 0x00C0},		 //
	{0x0F12, 0x00E0},		  //

	{0x002A, 0x0A3A},
	{0x0F12, 0x0002}, // skl_ThumbStartY_OffsetAF


//=======================================================
// 07.Flash Setting
//=======================================================
	{0x002A, 0x04C0},
	{0x0F12, 0x0002},		  //capture flash on
	{0x002A, 0x0C7C},
	{0x0F12, 0x0001},		  //one frame AE
	{0x002A, 0x0C4E},
	{0x0F12, 0x023C},		 //AWB R point
	{0x0F12, 0x0248},		  //AWB B point
	{0x002A, 0x0C82},
	{0x0F12, 0x0001},		  // Fls AE tune start
	{0x0F12, 0x0100},		  //Rin
	{0x0F12, 0x0120},
	{0x0F12, 0x0180},
	{0x0F12, 0x0200},
	{0x0F12, 0x0400},
	{0x0F12, 0x0800},
	{0x0F12, 0x0A00},
	{0x0F12, 0x1000},
	{0x0F12, 0x0100},		  //Rout
	{0x0F12, 0x00A0},
	{0x0F12, 0x0090},
	{0x0F12, 0x0080},
	{0x0F12, 0x0070},
	{0x0F12, 0x0045},
	{0x0F12, 0x0030},
	{0x0F12, 0x0010},
	{0x002A, 0x0CC4},
	{0x0F12, 0x0100},		  // flash NB default
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x002A, 0x0C68},
	{0x0F12, 0x0100},		  //flash WP_Weight default
	{0x0F12, 0x00C0},
	{0x0F12, 0x0080},
	{0x0F12, 0x000A},
	{0x0F12, 0x0000},
	{0x0F12, 0x0030},		  //flash WP_Lei_Thres default
	{0x0F12, 0x0040},
	{0x0F12, 0x0048},
	{0x0F12, 0x0050},
	{0x0F12, 0x0060},
	{0x002A, 0x0CD4},
	{0x0F12, 0x0120},		  //Fls  BRIn
	{0x0F12, 0x0150},
	{0x0F12, 0x0200},
	{0x0F12, 0x003C},		 // Fls  BROut
	{0x0F12, 0x003B},
	{0x0F12, 0x0026},		  //

//=======================================================
// 08.Auto Flicker Detection
//=======================================================
	{0x002A, 0x1276},
	{0x0F12, 0x0001},

// Auto Flicker (60Mhz start)
	{0x002A, 0x1270},
	{0x0F12, 0x0000},	//AFC_Default BIT[0] 1:60Hz 0:50Hz
	{0x002A, 0x051C},
	{0x0F12, 0x077F},	//

//=======================================================
// 09.AE Setting
//=======================================================
//AE Target
	{0x002A, 0x0B20},
	{0x0F12, 0x0036},

//ae_StatMode bit[3] BLC has to be bypassed to prevent AE weight change especially backlight scene
	{0x002A, 0x0B26},
	{0x0F12, 0x000F},
	{0x002A, 0x0854},
	{0x0F12, 0x0002},

//AE_state
	{0x002A, 0x081C},
	{0x0F12, 0x0111},
	{0x0F12, 0x00EF},

//AE Concept
	{0x002A, 0x08D4},
	{0x0F12, 0x0001},
	{0x0F12, 0x0001},

//Exposure
	{0x002A, 0x08DC},
	{0x0F12, 0x0001},
	{0x0F12, 0x0000},
	{0x0F12, 0x0A3C},
	{0x0F12, 0x0000},
	{0x0F12, 0x0D05},
	{0x0F12, 0x0000},
	{0x0F12, 0x4008},
	{0x0F12, 0x0000},
	{0x0F12, 0x7000},
	{0x0F12, 0x0000},
	{0x0F12, 0x9C00},
	{0x0F12, 0x0000},
	{0x0F12, 0xAD00},
	{0x0F12, 0x0001},
	{0x0F12, 0xF1D4},
	{0x0F12, 0x0002},
	{0x0F12, 0xDC00},
	{0x0F12, 0x0005},
	{0x0F12, 0xDC00},
	{0x0F12, 0x0005},

	{0x0F12, 0x0001},
	{0x0F12, 0x0000},
	{0x0F12, 0x0A3C},
	{0x0F12, 0x0000},
	{0x0F12, 0x0D05},
	{0x0F12, 0x0000},
	{0x0F12, 0x3408},
	{0x0F12, 0x0000},
	{0x0F12, 0x3408},
	{0x0F12, 0x0000},
	{0x0F12, 0x6B10},
	{0x0F12, 0x0000},
	{0x0F12, 0x8214},
	{0x0F12, 0x0000},
	{0x0F12, 0xC350},
	{0x0F12, 0x0000},
	{0x0F12, 0xD4C0},
	{0x0F12, 0x0001},
	{0x0F12, 0xD4C0},
	{0x0F12, 0x0001},

//Gain
	{0x002A, 0x08D8},
	{0x0F12, 0x0A00},
	{0x0F12, 0x0100},
	{0x002A, 0x086E},
	{0x0F12, 0x0A00},

// Lei Control
	{0x002A, 0x0984},
	{0x0F12, 0x3380},
	{0x002A, 0x097A},
	{0x0F12, 0x000C},	//lt_uMaxLei

	{0x002A, 0x0994},
	{0x0F12, 0x0002},
//AE speed
	{0x002A, 0x09AC},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x00C0},
	{0x0F12, 0x0040},
	{0x0F12, 0x00C0},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},


	{0x002A, 0x09BE},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},
	{0x0F12, 0x0100},


//=======================================================
// 10.AE Weight (Normal)
//=======================================================

	{0x002A, 0x0B2E},
	{0x0F12, 0x0100},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0001},
	{0x0F12, 0x0101},
	{0x0F12, 0x0201},
	{0x0F12, 0x0102},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0202},
	{0x0F12, 0x0202},
	{0x0F12, 0x0101},
	{0x0F12, 0x0201},
	{0x0F12, 0x0302},
	{0x0F12, 0x0203},
	{0x0F12, 0x0102},
	{0x0F12, 0x0201},
	{0x0F12, 0x0302},
	{0x0F12, 0x0203},
	{0x0F12, 0x0102},
	{0x0F12, 0x0101},
	{0x0F12, 0x0202},
	{0x0F12, 0x0202},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0201},
	{0x0F12, 0x0102},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},
	{0x0F12, 0x0101},

//======================================================
// 11.AWB-BASIC setting
//======================================================
// AWB init Start point
	{0x002A, 0x121C},
	{0x0F12, 0x0450},  //0x04CA  //0x0580
	{0x0F12, 0x0428},  //0x0400  //0x0428
	{0x0F12, 0x07B0},  //0x07C9  //0x07B0

// AWB Convergence Speed
	{0x0F12, 0x0008},
	{0x0F12, 0x0190},
	{0x0F12, 0x0100},	 //00A0
	{0x0F12, 0x0004},
	{0x0F12, 0x0002},

	{0x002A, 0x1208},
	{0x0F12, 0x0000},
	{0x0F12, 0xFFE0},
	{0x0F12, 0x0000},
	{0x002A, 0x1210},
	{0x0F12, 0x00C2},
	{0x0F12, 0x0002},
	{0x0F12, 0x0001},
	{0x0F12, 0x0134},	 //00074
	{0x002A, 0x121A},
	{0x0F12, 0x0001},

//// White Locus
	{0x002A, 0x0F88},
	{0x0F12, 0x0120},
	{0x0F12, 0x0121},
	{0x002A, 0x0FA2},
	{0x0F12, 0x041D},
	{0x002A, 0x0FA6},
	{0x0F12, 0x0000},
	{0x0F12, 0x0771},
	{0x0F12, 0x03A4},
	{0x0F12, 0x0036},
	{0x0F12, 0x0002},
	{0x002A, 0x0FBC},
	{0x0F12, 0x0080},	 //0x0032
	{0x0F12, 0x001E},

	{0x002A, 0x0F8C},
	{0x0F12, 0x02DF},
	{0x0F12, 0x0314},


////SceneDetectionMap
////awbb_SCDetectionMap_SEC_SceneDetectionMap[0]	 {0x0F12, 0x8F01},	// 70003C70
	{0x002A, 0x0FD4},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0500},
	{0x0F12, 0x5555},
	{0x0F12, 0x5455},
	{0x0F12, 0xAA55},
	{0x0F12, 0xAAAA},
	{0x0F12, 0xBF54},
	{0x0F12, 0xFFFF},
	{0x0F12, 0x54FE},
	{0x0F12, 0xFF6F},
	{0x0F12, 0xFEFF},
	{0x0F12, 0x1B54},
	{0x0F12, 0xFFFF},
	{0x0F12, 0x54FE},
	{0x0F12, 0xFF06},
	{0x0F12, 0xFEFF},
	{0x0F12, 0x0154},
	{0x0F12, 0xBFBF},
	{0x0F12, 0x54BE},

	{0x0F12, 0xFEF7},
	{0x0F12, 0x0021},
	{0x0F12, 0x0AF0},
	{0x0F12, 0x0AF0},
	{0x0F12, 0x018F},
	{0x0F12, 0x0096},
	{0x0F12, 0x000E},

	{0x002A, 0x0FC0},
	{0x0F12, 0x00C0},
	{0x0F12, 0x0010},
	{0x0F12, 0x0002},
	{0x002A, 0x2BAE},
	{0x0F12, 0x0006},

	{0x002A, 0x0F94},
	{0x0F12, 0x000C},
	{0x002A, 0x0FA0},
	{0x0F12, 0x0020},

//	{0x002A, 0x1014},
//	{0x0F12, 0x2000},
//	Indoor Zone
//	param_start	awbb_IndoorGrZones_m_BGrid	 {0x0F12, 0x0C00},	// 70003CD2
	{0x002A, 0x0DB4},
	{0x0F12, 0x0392},	//0392},	//awbb_IndoorGrZones_m_BGrid[0]	0432
	{0x0F12, 0x03D4},	//0450},	//awbb_IndoorGrZones_m_BGrid[1]	044A
	{0x0F12, 0x033C},	//0354},	//awbb_IndoorGrZones_m_BGrid[2]	0432
	{0x0F12, 0x0382},	//049E},	//awbb_IndoorGrZones_m_BGrid[3]	0418
	{0x0F12, 0x02F8},	//0322},	//awbb_IndoorGrZones_m_BGrid[4]	03FC
	{0x0F12, 0x034A},	//0484},	//awbb_IndoorGrZones_m_BGrid[5]	03D6
	{0x0F12, 0x02B6},	//030A},	//awbb_IndoorGrZones_m_BGrid[6]	036E
	{0x0F12, 0x0314},	//0446},	//awbb_IndoorGrZones_m_BGrid[7]	034C
	{0x0F12, 0x026E},	//02E2},	//awbb_IndoorGrZones_m_BGrid[8]	0308
	{0x0F12, 0x02F4},	//042E},	//awbb_IndoorGrZones_m_BGrid[9]	02EA
	{0x0F12, 0x0256},	//02BE},	//awbb_IndoorGrZones_m_BGrid[10]   02E0
	{0x0F12, 0x02E6},	//0400},	//awbb_IndoorGrZones_m_BGrid[11]   02CA
	{0x0F12, 0x023C},	//029C},	//awbb_IndoorGrZones_m_BGrid[12]   02C0
	{0x0F12, 0x02D2},	//03D2},	//awbb_IndoorGrZones_m_BGrid[13]   02B0
	{0x0F12, 0x0222},	//027A},	//awbb_IndoorGrZones_m_BGrid[14]   029E
	{0x0F12, 0x02C6},	//03A6},	//awbb_IndoorGrZones_m_BGrid[15]   0286
	{0x0F12, 0x0208},	//0262},	//awbb_IndoorGrZones_m_BGrid[16]   026A
	{0x0F12, 0x02A6},	//0382},	//awbb_IndoorGrZones_m_BGrid[17]   0250
	{0x0F12, 0x01F4},	//0250},	//awbb_IndoorGrZones_m_BGrid[18]   023E
	{0x0F12, 0x028C},	//0318},	//awbb_IndoorGrZones_m_BGrid[19]   0232
	{0x0F12, 0x01E6},	//0236},	//awbb_IndoorGrZones_m_BGrid[20]
	{0x0F12, 0x0278},	//02F4},	//awbb_IndoorGrZones_m_BGrid[21]
	{0x0F12, 0x01DE},	//0212},	//awbb_IndoorGrZones_m_BGrid[22]
	{0x0F12, 0x0262},	//02AC},	//awbb_IndoorGrZones_m_BGrid[23]
	{0x0F12, 0x0000},	//01FE},	//awbb_IndoorGrZones_m_BGrid[24]
	{0x0F12, 0x0000},	//0296},	//awbb_IndoorGrZones_m_BGrid[25]
	{0x0F12, 0x0000},	//01F0},	//awbb_IndoorGrZones_m_BGrid[26]
	{0x0F12, 0x0000},	//0288},	//awbb_IndoorGrZones_m_BGrid[27]
	{0x0F12, 0x0000},	//01E0},	//awbb_IndoorGrZones_m_BGrid[28]
	{0x0F12, 0x0000},	//0274},	//awbb_IndoorGrZones_m_BGrid[29]
	{0x0F12, 0x0000},	//01D2},	//awbb_IndoorGrZones_m_BGrid[30]
	{0x0F12, 0x0000},	//026E},	//awbb_IndoorGrZones_m_BGrid[31]
	{0x0F12, 0x0000},	//01C6},	//awbb_IndoorGrZones_m_BGrid[32]
	{0x0F12, 0x0000},	//0258},	//awbb_IndoorGrZones_m_BGrid[33]
	{0x0F12, 0x0000},	//01B4},	//awbb_IndoorGrZones_m_BGrid[34]
	{0x0F12, 0x0000},	//0246},	//awbb_IndoorGrZones_m_BGrid[35]
	{0x0F12, 0x0000},	//019C},	//awbb_IndoorGrZones_m_BGrid[36]
	{0x0F12, 0x0000},	//022E},	//awbb_IndoorGrZones_m_BGrid[37]
	{0x0F12, 0x0000},	//0000},	//awbb_IndoorGrZones_m_BGrid[38]
	{0x0F12, 0x0000},	//0000},	//awbb_IndoorGrZones_m_BGrid[39]
//	param_end			awbb_IndoorGrZones_m_BGrid
//	param_start			awbb_IndoorGrZones_m_GridStep	  {0x0F12, 0x2900},	// 70003D26
	{0x0F12, 0x0005},	//awbb_IndoorGrZones_m_GridStep[0]
	{0x0F12, 0x0000},	//awbb_IndoorGrZones_m_GridStep[1]
//	param_end			awbb_IndoorGrZones_m_GridStep
//	param_start			awbb_IndoorGrZones_ZInfo_m_GridSz	{0x0F12, 0xFB45},	// 70003D2C
	{0x0F12, 0x000C},   //awbb_IndoorGrZones_ZInfo_m_GridSz[0]
	{0x0F12, 0x0000},   //awbb_IndoorGrZones_ZInfo_m_GridSz[1]
//	param_end			awbb_IndoorGrZones_ZInfo_m_GridSz
//	param_start			awbb_IndoorGrZones_m_Boffs
	{0x0F12, 0x014A},	//awbb_IndoorGrZones_m_Boffs[0]
	{0x0F12, 0x0000},	//awbb_IndoorGrZones_m_Boffs[1]
//	param_end			awbb_IndoorGrZones_m_Boffs

// Outdoor Zone
	{0x002A, 0x0E10},
	{0x0F12, 0x0272},
	{0x0F12, 0x02A0},
	{0x0F12, 0x025A},
	{0x0F12, 0x02BC},
	{0x0F12, 0x024A},
	{0x0F12, 0x02C0},
	{0x0F12, 0x023C},
	{0x0F12, 0x02BE},
	{0x0F12, 0x022E},
	{0x0F12, 0x02BC},
	{0x0F12, 0x0224},
	{0x0F12, 0x02B6},
	{0x0F12, 0x0218},
	{0x0F12, 0x02AA},
	{0x0F12, 0x0210},
	{0x0F12, 0x02A0},
	{0x0F12, 0x020C},
	{0x0F12, 0x0296},
	{0x0F12, 0x020A},
	{0x0F12, 0x028C},
	{0x0F12, 0x0212},
	{0x0F12, 0x027E},
	{0x0F12, 0x0234},
	{0x0F12, 0x0256},

	{0x0F12, 0x0004},
	{0x002A, 0x0E44},
	{0x0F12, 0x000C},
	{0x002A, 0x0E48},
	{0x0F12, 0x01D8},

// Low Brightness Zone
	{0x002A, 0x0E4C},
	{0x0F12, 0x036C},
	{0x0F12, 0x0408},
	{0x0F12, 0x02D0},
	{0x0F12, 0x038A},
	{0x0F12, 0x0262},
	{0x0F12, 0x0320},
	{0x0F12, 0x0222},
	{0x0F12, 0x02F4},
	{0x0F12, 0x01EA},
	{0x0F12, 0x02D4},
	{0x0F12, 0x01CC},
	{0x0F12, 0x029E},
	{0x0F12, 0x01A4},
	{0x0F12, 0x027E},
	{0x0F12, 0x0184},
	{0x0F12, 0x0230},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
   // {0x0F12, 0x0000},
	{0x002A, 0x0E7C},
	{0x0F12, 0x0006},
	{0x002A, 0x0E80},
	{0x0F12, 0x0008},
	{0x002A, 0x0E84},
	{0x0F12, 0x0136},

//// Low Temp. Zone
	{0x002A, 0x0E88},
	{0x0F12, 0x0380},
	{0x0F12, 0x0000},
	{0x0F12, 0x0168},
	{0x0F12, 0x0000},
	{0x0F12, 0x2D90},
	{0x0F12, 0x0000},

////AWB - GridCorrection
	{0x002A, 0x11EC},
	{0x0F12, 0x02CE},
	{0x0F12, 0x0347},
	{0x0F12, 0x03C2},

	{0x0F12, 0x10A0},
	{0x0F12, 0x10A1},
	{0x0F12, 0x1185},
	{0x0F12, 0x1186},
	{0x0F12, 0x11E5},
	{0x0F12, 0x11E6},
	{0x0F12, 0x11E6},

	{0x0F12, 0x00AB},
	{0x0F12, 0x00BF},
	{0x0F12, 0x00D2},
	{0x0F12, 0x0093},

// Indoor Grid Offset
	{0x002A, 0x113C},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0xFF98},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},

// Outdoor Grid Offset
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
//======================================================
// 12.CCM Setting
//======================================================

	{0x002A, 0x146A},
	{0x0F12, 0x00B0},
	{0x0F12, 0x00F0},
	{0x0F12, 0x0100},
	{0x0F12, 0x0120},
	{0x0F12, 0x0150},
	{0x0F12, 0x0180},

	{0x0F12, 0x0001},

	{0x002A, 0x145C},
	{0x0F12, 0x4800},
	{0x0F12, 0x2000},
	{0x002A, 0x1464},
	{0x0F12, 0x48D8},
	{0x0F12, 0x2000},

	{0x002A, 0x4800},
	{0x0F12, 0x021A}, //TVAR_wbt_pBaseCcms[0] // Horizon
	{0x0F12, 0xFFBE}, //TVAR_wbt_pBaseCcms[1]
	{0x0F12, 0xFFE0}, //TVAR_wbt_pBaseCcms[2]
	{0x0F12, 0xFEF1}, //TVAR_wbt_pBaseCcms[3]
	{0x0F12, 0x014E}, //TVAR_wbt_pBaseCcms[4]
	{0x0F12, 0xFF18}, //TVAR_wbt_pBaseCcms[5]
	{0x0F12, 0xFFE6}, //TVAR_wbt_pBaseCcms[6]
	{0x0F12, 0xFFDD}, //TVAR_wbt_pBaseCcms[7]
	{0x0F12, 0x01B2}, //TVAR_wbt_pBaseCcms[8]
	{0x0F12, 0x0133}, //TVAR_wbt_pBaseCcms[9]
	{0x0F12, 0x00D4}, //TVAR_wbt_pBaseCcms[10]
	{0x0F12, 0xFF7E}, //TVAR_wbt_pBaseCcms[11]
	{0x0F12, 0x0151}, //TVAR_wbt_pBaseCcms[12]
	{0x0F12, 0xFF50}, //TVAR_wbt_pBaseCcms[13]
	{0x0F12, 0x0147}, //TVAR_wbt_pBaseCcms[14]
	{0x0F12, 0xFF82}, //TVAR_wbt_pBaseCcms[15]
	{0x0F12, 0x01F7}, //TVAR_wbt_pBaseCcms[16]
	{0x0F12, 0x0144}, //TVAR_wbt_pBaseCcms[17]

	{0x0F12, 0x021A},	//TVAR_wbt_pBaseCcms[18] // IncandA
	{0x0F12, 0xFFBE},	//TVAR_wbt_pBaseCcms[19]
	{0x0F12, 0xFFE0},	//TVAR_wbt_pBaseCcms[20]
	{0x0F12, 0xFEF1},	//TVAR_wbt_pBaseCcms[21]
	{0x0F12, 0x014E},	//TVAR_wbt_pBaseCcms[22]
	{0x0F12, 0xFF18},	//TVAR_wbt_pBaseCcms[23]
	{0x0F12, 0xFFE6},	//TVAR_wbt_pBaseCcms[24]
	{0x0F12, 0xFFDD},	//TVAR_wbt_pBaseCcms[25]
	{0x0F12, 0x01B2},	//TVAR_wbt_pBaseCcms[26]
	{0x0F12, 0x0133},	//TVAR_wbt_pBaseCcms[27]
	{0x0F12, 0x00D4},	//TVAR_wbt_pBaseCcms[28]
	{0x0F12, 0xFF7E},	//TVAR_wbt_pBaseCcms[29]
	{0x0F12, 0x0151},	//TVAR_wbt_pBaseCcms[30]
	{0x0F12, 0xFF50},	//TVAR_wbt_pBaseCcms[31]
	{0x0F12, 0x0147},	//TVAR_wbt_pBaseCcms[32]
	{0x0F12, 0xFF82},	//TVAR_wbt_pBaseCcms[33]
	{0x0F12, 0x01F7},	//TVAR_wbt_pBaseCcms[34]
	{0x0F12, 0x0144},	//TVAR_wbt_pBaseCcms[35]

	{0x0F12, 0x021A},   //TVAR_wbt_pBaseCcms[36] // WW	  0002
	{0x0F12, 0xFFBE},   //TVAR_wbt_pBaseCcms[37]			FFE5
	{0x0F12, 0xFFE0},   //TVAR_wbt_pBaseCcms[38]			FEF8
	{0x0F12, 0xFEF1},   //TVAR_wbt_pBaseCcms[39]			FFDA
	{0x0F12, 0x014E},   //TVAR_wbt_pBaseCcms[40]			00ED
	{0x0F12, 0xFF18},   //TVAR_wbt_pBaseCcms[41]			FF37
	{0x0F12, 0xFFE6},   //TVAR_wbt_pBaseCcms[42]			FF52
	{0x0F12, 0xFFDD},   //TVAR_wbt_pBaseCcms[43]			FF5D
	{0x0F12, 0x01B2},   //TVAR_wbt_pBaseCcms[44]			0192
	{0x0F12, 0x0133},   //TVAR_wbt_pBaseCcms[45]
	{0x0F12, 0x00D4},   //TVAR_wbt_pBaseCcms[46]
	{0x0F12, 0xFF7E},   //TVAR_wbt_pBaseCcms[47]
	{0x0F12, 0x0151},   //TVAR_wbt_pBaseCcms[48]
	{0x0F12, 0xFF50},   //TVAR_wbt_pBaseCcms[49]
	{0x0F12, 0x0147},   //TVAR_wbt_pBaseCcms[50]
	{0x0F12, 0xFF82},   //TVAR_wbt_pBaseCcms[51]
	{0x0F12, 0x01F7},   //TVAR_wbt_pBaseCcms[52]
	{0x0F12, 0x0144},   //TVAR_wbt_pBaseCcms[53]

	{0x0F12, 0x021A},   //01C7 //TVAR_wbt_pBaseCcms[54] // CW	 /TVA
	{0x0F12, 0xFFBE},   //FFD6 //TVAR_wbt_pBaseCcms[55]		   /TVA
	{0x0F12, 0xFFE0},   //000A //TVAR_wbt_pBaseCcms[56]		   /TVA
	{0x0F12, 0xFEF1},   //FEF1 //TVAR_wbt_pBaseCcms[57]		   /TVA
	{0x0F12, 0x014E},   //014E //TVAR_wbt_pBaseCcms[58]		   /TVA
	{0x0F12, 0xFF18},   //FF18 //TVAR_wbt_pBaseCcms[59]		   /TVA
	{0x0F12, 0xFFE6},   //FFE6 //TVAR_wbt_pBaseCcms[60]		   /TVA
	{0x0F12, 0xFFDD},   //FFDD //TVAR_wbt_pBaseCcms[61]		   /TVA
	{0x0F12, 0x01B2},   //01B2 //TVAR_wbt_pBaseCcms[62]		   /TVA
	{0x0F12, 0x0133},   //00F2 //TVAR_wbt_pBaseCcms[63]
	{0x0F12, 0x00D4},   //00CA //TVAR_wbt_pBaseCcms[64]
	{0x0F12, 0xFF7E},   //FF48 //TVAR_wbt_pBaseCcms[65]
	{0x0F12, 0x0151},   //0151 //TVAR_wbt_pBaseCcms[66]
	{0x0F12, 0xFF50},   //FF50 //TVAR_wbt_pBaseCcms[67]
	{0x0F12, 0x0147},   //0147 //TVAR_wbt_pBaseCcms[68]
	{0x0F12, 0xFF82},   //FF75 //TVAR_wbt_pBaseCcms[69]
	{0x0F12, 0x01F7},   //0187 //TVAR_wbt_pBaseCcms[70]
	{0x0F12, 0x0144},   //01BF //TVAR_wbt_pBaseCcms[71]

	{0x0F12, 0x021A},   //01C7 //TVAR_wbt_pBaseCcms[72] // D50
	{0x0F12, 0xFFBE},   //FFD6 //TVAR_wbt_pBaseCcms[73]
	{0x0F12, 0xFFE0},   //000A //TVAR_wbt_pBaseCcms[74]
	{0x0F12, 0xFEF1},   //FEF1 //TVAR_wbt_pBaseCcms[75]
	{0x0F12, 0x014E},   //014E //TVAR_wbt_pBaseCcms[76]
	{0x0F12, 0xFF18},   //FF18 //TVAR_wbt_pBaseCcms[77]
	{0x0F12, 0xFFE6},   //FFE6 //TVAR_wbt_pBaseCcms[78]
	{0x0F12, 0xFFDD},   //FFDD //TVAR_wbt_pBaseCcms[79]
	{0x0F12, 0x01B2},   //01B2 //TVAR_wbt_pBaseCcms[80]
	{0x0F12, 0x0133},   //00F2 //TVAR_wbt_pBaseCcms[81]
	{0x0F12, 0x00D4},   //00CA //TVAR_wbt_pBaseCcms[82]
	{0x0F12, 0xFF7E},   //FF48 //TVAR_wbt_pBaseCcms[83]
	{0x0F12, 0x0151},   //0151 //TVAR_wbt_pBaseCcms[84]
	{0x0F12, 0xFF50},   //FF50 //TVAR_wbt_pBaseCcms[85]
	{0x0F12, 0x0147},   //0147 //TVAR_wbt_pBaseCcms[86]
	{0x0F12, 0xFF82},   //FF75 //TVAR_wbt_pBaseCcms[87]
	{0x0F12, 0x01F7},   //0187 //TVAR_wbt_pBaseCcms[88]
	{0x0F12, 0x0144},   //01BF //TVAR_wbt_pBaseCcms[89]

	{0x0F12, 0x021A},  //0203 //01C7 //TVAR_wbt_pBaseCcms[90] // D65
	{0x0F12, 0xFFBE},  //FFAD //FFD6 //TVAR_wbt_pBaseCcms[91]
	{0x0F12, 0xFFE0},  //FFFB //000A //TVAR_wbt_pBaseCcms[92]
	{0x0F12, 0xFEF1},  //FEF1 //FF25 //TVAR_wbt_pBaseCcms[93]
	{0x0F12, 0x014E},  //014E //019E //TVAR_wbt_pBaseCcms[94]
	{0x0F12, 0xFF18},  //FF18 //FF6D //TVAR_wbt_pBaseCcms[95]
	{0x0F12, 0xFFE6},  //FFE6 //0022 //TVAR_wbt_pBaseCcms[96]
	{0x0F12, 0xFFDD},  //FFDD //FFC7 //TVAR_wbt_pBaseCcms[97]
	{0x0F12, 0x01B2},  //01B2 //019D //TVAR_wbt_pBaseCcms[98]
	{0x0F12, 0x0133},  //0133 //00C2 //TVAR_wbt_pBaseCcms[99]
	{0x0F12, 0x00D4},  //00D4 //009A //TVAR_wbt_pBaseCcms[100]
	{0x0F12, 0xFF7E},  //FF7E //FEFD //TVAR_wbt_pBaseCcms[101]
	{0x0F12, 0x0151},  //0151 //01F3 //TVAR_wbt_pBaseCcms[102]
	{0x0F12, 0xFF50},  //FF50 //FF7C //TVAR_wbt_pBaseCcms[103]
	{0x0F12, 0x0147},  //0147 //01A6 //TVAR_wbt_pBaseCcms[104]
	{0x0F12, 0xFF82},  //FF75 //FF06 //TVAR_wbt_pBaseCcms[105]
	{0x0F12, 0x01F7},  //0187 //01BA //TVAR_wbt_pBaseCcms[106]
	{0x0F12, 0x0144},  //01BF //0108 //TVAR_wbt_pBaseCcms[107]

	{0x0F12, 0x0205},   //0206 //TVAR_wbt_pOutdoorCcm[0]
	{0x0F12, 0xFFB7},   //FFD3 //TVAR_wbt_pOutdoorCcm[1]
	{0x0F12, 0xFFEF},   //FFD2 //TVAR_wbt_pOutdoorCcm[2]
	{0x0F12, 0xFF56},   //FF56 //TVAR_wbt_pOutdoorCcm[3]
	{0x0F12, 0x01A2},   //01A2 //TVAR_wbt_pOutdoorCcm[4]
	{0x0F12, 0xFE5F},   //FE5F //TVAR_wbt_pOutdoorCcm[5]
	{0x0F12, 0xFFA6},   //FFA6 //TVAR_wbt_pOutdoorCcm[6]
	{0x0F12, 0x0021},   //0021 //TVAR_wbt_pOutdoorCcm[7]
	{0x0F12, 0x018E},   //018E //TVAR_wbt_pOutdoorCcm[8]
	{0x0F12, 0x00F2},   //00F2 //TVAR_wbt_pOutdoorCcm[9]
	{0x0F12, 0x011A},   //011A //TVAR_wbt_pOutdoorCcm[10]
	{0x0F12, 0xFF79},   //FF79 //TVAR_wbt_pOutdoorCcm[11]
	{0x0F12, 0x0151},   //0151 //TVAR_wbt_pOutdoorCcm[12]
	{0x0F12, 0xFF50},   //FF50 //TVAR_wbt_pOutdoorCcm[13]
	{0x0F12, 0x0147},   //0147 //TVAR_wbt_pOutdoorCcm[14]
	{0x0F12, 0xFF82},   //FF75 //TVAR_wbt_pOutdoorCcm[15]
	{0x0F12, 0x01F7},   //0187 //TVAR_wbt_pOutdoorCcm[16]
	{0x0F12, 0x0144},   //01BF //TVAR_wbt_pOutdoorCcm[17]


 //====================================================
// 13.GAMMA
//=====================================================
// Indoor Gamma
	{0x002A, 0x12F4},
	{0x0F12, 0x0000},
	{0x0F12, 0x000A},
	{0x0F12, 0x0016},
	{0x0F12, 0x0030},
	{0x0F12, 0x0066},
	{0x0F12, 0x00D5},
	{0x0F12, 0x0138},
	{0x0F12, 0x0163},
	{0x0F12, 0x0189},
	{0x0F12, 0x01C6},
	{0x0F12, 0x01F8},
	{0x0F12, 0x0222},
	{0x0F12, 0x023D},
	{0x0F12, 0x026E},
	{0x0F12, 0x029C},
	{0x0F12, 0x02EC},
	{0x0F12, 0x032D},
	{0x0F12, 0x036E},
	{0x0F12, 0x03B2},
	{0x0F12, 0x03FF},
	{0x0F12, 0x0000},
	{0x0F12, 0x000A},
	{0x0F12, 0x0016},
	{0x0F12, 0x0030},
	{0x0F12, 0x0066},
	{0x0F12, 0x00D5},
	{0x0F12, 0x0138},
	{0x0F12, 0x0163},
	{0x0F12, 0x0189},
	{0x0F12, 0x01C6},
	{0x0F12, 0x01F8},
	{0x0F12, 0x0222},
	{0x0F12, 0x023D},
	{0x0F12, 0x026E},
	{0x0F12, 0x029C},
	{0x0F12, 0x02EC},
	{0x0F12, 0x032D},
	{0x0F12, 0x036E},
	{0x0F12, 0x03B2},
	{0x0F12, 0x03FF},
	{0x0F12, 0x0000},
	{0x0F12, 0x000A},
	{0x0F12, 0x0016},
	{0x0F12, 0x0030},
	{0x0F12, 0x0066},
	{0x0F12, 0x00D5},
	{0x0F12, 0x0138},
	{0x0F12, 0x0163},
	{0x0F12, 0x0189},
	{0x0F12, 0x01C6},
	{0x0F12, 0x01F8},
	{0x0F12, 0x0222},
	{0x0F12, 0x023D},
	{0x0F12, 0x026E},
	{0x0F12, 0x029C},
	{0x0F12, 0x02EC},
	{0x0F12, 0x032D},
	{0x0F12, 0x036E},
	{0x0F12, 0x03B2},
	{0x0F12, 0x03FF},
// Outdoor Gamma
	{0x0F12, 0x0000},
	{0x0F12, 0x000A},
	{0x0F12, 0x0016},
	{0x0F12, 0x0030},
	{0x0F12, 0x0066},
	{0x0F12, 0x00D5},
	{0x0F12, 0x0138},
	{0x0F12, 0x0163},
	{0x0F12, 0x0189},
	{0x0F12, 0x01C6},
	{0x0F12, 0x01F8},
	{0x0F12, 0x0222},
	{0x0F12, 0x023D},
	{0x0F12, 0x026E},
	{0x0F12, 0x029C},
	{0x0F12, 0x02EC},
	{0x0F12, 0x032D},
	{0x0F12, 0x036E},
	{0x0F12, 0x03B2},
	{0x0F12, 0x03FF},
	{0x0F12, 0x0000},
	{0x0F12, 0x000A},
	{0x0F12, 0x0016},
	{0x0F12, 0x0030},
	{0x0F12, 0x0066},
	{0x0F12, 0x00D5},
	{0x0F12, 0x0138},
	{0x0F12, 0x0163},
	{0x0F12, 0x0189},
	{0x0F12, 0x01C6},
	{0x0F12, 0x01F8},
	{0x0F12, 0x0222},
	{0x0F12, 0x023D},
	{0x0F12, 0x026E},
	{0x0F12, 0x029C},
	{0x0F12, 0x02EC},
	{0x0F12, 0x032D},
	{0x0F12, 0x036E},
	{0x0F12, 0x03B2},
	{0x0F12, 0x03FF},
	{0x0F12, 0x0000},
	{0x0F12, 0x000A},
	{0x0F12, 0x0016},
	{0x0F12, 0x0030},
	{0x0F12, 0x0066},
	{0x0F12, 0x00D5},
	{0x0F12, 0x0138},
	{0x0F12, 0x0163},
	{0x0F12, 0x0189},
	{0x0F12, 0x01C6},
	{0x0F12, 0x01F8},
	{0x0F12, 0x0222},
	{0x0F12, 0x023D},
	{0x0F12, 0x026E},
	{0x0F12, 0x029C},
	{0x0F12, 0x02EC},
	{0x0F12, 0x032D},
	{0x0F12, 0x036E},
	{0x0F12, 0x03B2},
	{0x0F12, 0x03FF},


//=====================================================
// 14.AFIT
//=====================================================
//Tune//5EA //FPGA
	{0x002A, 0x14FC},
	{0x0F12, 0x003F},
	{0x0F12, 0x0083},
	{0x0F12, 0x012F},
	{0x0F12, 0x01F0},	//B0
	{0x0F12, 0x0255},

	{0x002A, 0x14F0},
	{0x0F12, 0x0000},	// on/off AFIT by NB option

	{0x0F12, 0x0014},
	{0x0F12, 0x00D2},
	{0x0F12, 0x0384},
	{0x0F12, 0x07D0},
	{0x0F12, 0x1388},

	{0x002A, 0x152E},
	{0x0F12, 0x0070},
	{0x0F12, 0x0005},

	{0x0F12, 0x0180},
	{0x0F12, 0x0196},

//	AFIT 0
	{0x002A, 0x1538},
	{0x0F12, 0x0000},  //AFIT16_BRIGHTNESS
	{0x0F12, 0x0000},  //AFIT16_CONTRAST
	{0x0F12, 0x0000},  //AFIT16_SATURATION
	{0x0F12, 0x0000},  //AFIT16_SHARP_BLUR
	{0x0F12, 0x0000},  //AFIT16_GLAMOUR
	{0x0F12, 0x0064},  //AFIT16_EE_iFlatBoundary
	{0x0F12, 0x0020},  //AFIT16_Yuvemix_mNegRanges_0
	{0x0F12, 0x0050},  //AFIT16_Yuvemix_mNegRanges_1
	{0x0F12, 0x0080},  //AFIT16_Yuvemix_mNegRanges_2
	{0x0F12, 0x0008},  //AFIT16_Yuvemix_mPosRanges_0
	{0x0F12, 0x0020},  //AFIT16_Yuvemix_mPosRanges_1
	{0x0F12, 0x0050},  //AFIT16_Yuvemix_mPosRanges_2
	{0x0F12, 0x2F18},  //AFIT8_Dspcl_edge_low [7:0] AFIT8_Dspcl_edge_high [15:8]
	{0x0F12, 0x001A},  //AFIT8_Dspcl_repl_thresh [7:0] AFIT8_Dspcl_iConnectedThresh [15:8]
	{0x0F12, 0x3C24},  //AFIT8_Dspcl_iPlainLevel [7:0] AFIT8_Dspcl_iSatThresh [15:8]
	{0x0F12, 0x0C01},  //AFIT8_Dspcl_iPlainReference_H [7:0] AFIT8_Dspcl_iVarianceMultThresh_H [15:8]
	{0x0F12, 0x100C},  //AFIT8_Dspcl_iVariancePlainMax_H [7:0] AFIT8_Dspcl_iVarianceLimitMax_H [15:8]
	{0x0F12, 0x0101},  //AFIT8_Dspcl_nClustLevel_C [7:0] AFIT8_Dspcl_iPlainReference_C [15:8]
	{0x0F12, 0x0C0C},  //AFIT8_Dspcl_iVarianceMultThresh_C [7:0] AFIT8_Dspcl_iVariancePlainMax_C [15:8]
	{0x0F12, 0x3010},  //AFIT8_Dspcl_iVarianceLimitMax_C [7:0] AFIT8_EE_iShVLowRegion [15:8]
	{0x0F12, 0x100C},  //AFIT8_EE_iFSmagPosPwrLow [7:0] AFIT8_EE_iFSmagPosPwrHigh [15:8]
	{0x0F12, 0x100C},  //AFIT8_EE_iFSmagNegPwrLow [7:0] AFIT8_EE_iFSmagNegPwrHigh [15:8]
	{0x0F12, 0x0000},  //AFIT8_EE_iFSThLow [7:0] AFIT8_EE_iFSThHigh [15:8]
	{0x0F12, 0x0C08},  //AFIT8_EE_iXformTh_High [7:0] AFIT8_EE_iXformTh_Low [15:8]
	{0x0F12, 0x0C0C},  //AFIT8_EE_iVLowFSmagPower [7:0] AFIT8_EE_iVLowiXformTh [15:8]
	{0x0F12, 0x0610},  //AFIT8_EE_iReduceNoiseRatio [7:0] AFIT8_EE_iFlatSpan [15:8]
	{0x0F12, 0x1008},  //AFIT8_EE_iMSharpenLow [7:0] AFIT8_EE_iMSharpenHigh [15:8]
	{0x0F12, 0x105A},  //AFIT8_EE_iFlatMean [7:0] AFIT8_EE_iFlatOffset [15:8]
	{0x0F12, 0x0000},  //AFIT8_EE_iMShThLow [7:0] AFIT8_EE_iMShThHigh [15:8]
	{0x0F12, 0x0406},  //AFIT8_EE_iMShDirThLow [7:0] AFIT8_EE_iMShDirThHigh [15:8]
	{0x0F12, 0x0608},  //AFIT8_EE_iMShVLowPwr [7:0] AFIT8_EE_iMShVLowThrld [15:8]
	{0x0F12, 0x180C},  //AFIT8_EE_iWSharpenPosLow [7:0] AFIT8_EE_iWSharpenPosHigh [15:8]
	{0x0F12, 0x180C},  //AFIT8_EE_iWSharpenNegLow [7:0] AFIT8_EE_iWSharpenNegHigh [15:8]
	{0x0F12, 0x0204},  //AFIT8_EE_iWShThLow [7:0] AFIT8_EE_iWShThHigh [15:8]
	{0x0F12, 0x040C},  //AFIT8_EE_iWShVLowPwr [7:0] AFIT8_EE_iWShVLowThrld [15:8]
	{0x0F12, 0x5A00},  //AFIT8_EE_iReduceNegative [7:0] AFIT8_EE_iRadialLimitSh [15:8]
	{0x0F12, 0x4003},  //AFIT8_EE_iRadialPowerSh [7:0] AFIT8_Bdns_iDispTH_L [15:8]
	{0x0F12, 0x0440},  //AFIT8_Bdns_iDispTH_H [7:0] AFIT8_Bdns_iDispLimit_L [15:8]
	{0x0F12, 0x0A04},  //AFIT8_Bdns_iDispLimit_H [7:0] AFIT8_Bdns_iDispTH4HF [15:8]
	{0x0F12, 0x0101},  //AFIT8_Bdns_iDispLimit4HF_L [7:0] AFIT8_Bdns_iDispLimit4HF_H [15:8]
	{0x0F12, 0x283C},  //AFIT8_Bdns_iDenoiseTH_G_L [7:0] AFIT8_Bdns_iDenoiseTH_G_H [15:8]
	{0x0F12, 0x283C},  //AFIT8_Bdns_iDenoiseTH_NG_L [7:0] AFIT8_Bdns_iDenoiseTH_NG_H [15:8]
	{0x0F12, 0x0601},  //AFIT8_Bdns_iDistSigmaMin [7:0] AFIT8_Bdns_iDistSigmaMax [15:8]
	{0x0F12, 0x3C3C},  //AFIT8_Bdns_iDenoiseTH_Add_Plain [7:0] AFIT8_Bdns_iDenoiseTH_Add_Direc [15:8]
	{0x0F12, 0x5004},  //AFIT8_Bdns_iDirConfidenceMin [7:0] AFIT8_Bdns_iDirConfidenceMax [15:8]
	{0x0F12, 0x7808},  //AFIT8_Bdns_iPatternTH_MIN [7:0] AFIT8_Bdns_iPatternTH_MAX [15:8]
	{0x0F12, 0x3C00},  //AFIT8_Bdns_iNRTune [7:0] AFIT8_Bdns_iLowMaxSlopeAllowed [15:8]
	{0x0F12, 0x5A3C},  //AFIT8_Bdns_iHighMaxSlopeAllowed [7:0] AFIT8_Bdns_iRadialLimitNR [15:8]
	{0x0F12, 0x0C04},  //AFIT8_Bdns_iRadialPowerNR [7:0] AFIT8_Dmsc_iEnhThresh [15:8]
	{0x0F12, 0x0F08},  //AFIT8_Dmsc_iDesatThresh [7:0] AFIT8_Dmsc_iDemBlurLow [15:8]
	{0x0F12, 0x050F},  //AFIT8_Dmsc_iDemBlurHigh [7:0] AFIT8_Dmsc_iDemBlurRange [15:8]
	{0x0F12, 0x8006},  //AFIT8_Dmsc_iDecisionThresh [7:0] AFIT8_Dmsc_iCentGrad [15:8]
	{0x0F12, 0x0020},  //AFIT8_Dmsc_iMonochrom [7:0] AFIT8_Dmsc_iGRDenoiseVal [15:8]
	{0x0F12, 0x0000},  //AFIT8_Dmsc_iGBDenoiseVal [7:0] AFIT8_Dmsc_iEdgeDesatThrLow [15:8]
	{0x0F12, 0x1800},  //AFIT8_Dmsc_iEdgeDesatThrHigh [7:0] AFIT8_Dmsc_iEdgeDesat [15:8]
	{0x0F12, 0x0000},  //AFIT8_Dmsc_iEdgeDesatLimit [7:0] AFIT8_Dmsc_iNearGrayDesat [15:8]
	{0x0F12, 0xE119},  //AFIT8_Postdmsc_iLowBright [7:0] AFIT8_Postdmsc_iHighBright [15:8]
	{0x0F12, 0x7D0D},  //AFIT8_Postdmsc_iLowSat [7:0] AFIT8_Postdmsc_iHighSat [15:8]
	{0x0F12, 0x1E10},  //AFIT8_Postdmsc_iBCoeff [7:0] AFIT8_Postdmsc_iGCoeff [15:8]
	{0x0F12, 0x1C09},  //AFIT8_Postdmsc_iWideMult [7:0] AFIT8_Postdmsc_iTune [15:8]
	{0x0F12, 0x0A00},  //AFIT8_Postdmsc_NoisePower_Low [7:0] AFIT8_Postdmsc_NoisePower_High [15:8]
	{0x0F12, 0x0A00},  //AFIT8_Postdmsc_NoisePower_VLow [7:0] AFIT8_Postdmsc_NoiseLimit_Low [15:8]
	{0x0F12, 0x0A0A},  //AFIT8_Postdmsc_NoiseLimit_High [7:0] AFIT8_Postdmsc_iSkinNS [15:8]
	{0x0F12, 0x0308},  //AFIT8_Postdmsc_iReduceNS_EdgeTh [7:0] AFIT8_Postdmsc_iReduceNS_Slope [15:8]
	{0x0F12, 0x0700},  //AFIT8_Yuvemix_mNegSlopes_0 [7:0] AFIT8_Yuvemix_mNegSlopes_1 [15:8]
	{0x0F12, 0x0506},  //AFIT8_Yuvemix_mNegSlopes_2 [7:0] AFIT8_Yuvemix_mNegSlopes_3 [15:8]
	{0x0F12, 0x0700},  //AFIT8_Yuvemix_mPosSlopes_0 [7:0] AFIT8_Yuvemix_mPosSlopes_1 [15:8]
	{0x0F12, 0x0506},  //AFIT8_Yuvemix_mPosSlopes_2 [7:0] AFIT8_Yuvemix_mPosSlopes_3 [15:8]
	{0x0F12, 0x1414},  //AFIT8_Yuviirnr_iYThreshL [7:0] AFIT8_Yuviirnr_iYThreshH [15:8]
	{0x0F12, 0x1212},  //AFIT8_Yuviirnr_iYNRStrengthL [7:0] AFIT8_Yuviirnr_iYNRStrengthH [15:8]
	{0x0F12, 0x080C},  //AFIT8_Yuviirnr_iUVThreshL [7:0] AFIT8_Yuviirnr_iUVThreshH [15:8]
	{0x0F12, 0x0C10},  //AFIT8_Yuviirnr_iDiffThreshL_UV [7:0] AFIT8_Yuviirnr_iDiffThreshH_UV [15:8]
	{0x0F12, 0x0406},  //AFIT8_Yuviirnr_iMaxThreshL_UV [7:0] AFIT8_Yuviirnr_iMaxThreshH_UV [15:8]
	{0x0F12, 0x1F1F},  //AFIT8_Yuviirnr_iUVNRStrengthL [7:0] AFIT8_Yuviirnr_iUVNRStrengthH [15:8]
	{0x0F12, 0x8080},  //AFIT8_byr_gras_iShadingPower [7:0] AFIT8_RGBGamma2_iLinearity [15:8]
	{0x0F12, 0x8018},  //AFIT8_RGBGamma2_iDarkReduce [7:0] AFIT8_ccm_oscar_iSaturation [15:8]
	{0x0F12, 0x8000},  //AFIT8_RGB2YUV_iYOffset [7:0] AFIT8_RGB2YUV_iRGBGain [15:8]
	{0x0F12, 0x2001},  //AFIT8_Dspcl_nClustLevel_H [7:0] AFIT8_EE_iLowSharpPower [15:8]
	{0x0F12, 0x0140},  //AFIT8_EE_iHighSharpPower [7:0] AFIT8_Dspcl_nClustLevel_H_Bin [15:8]
	{0x0F12, 0x4020},  //AFIT8_EE_iLowSharpPower_Bin [7:0] AFIT8_EE_iHighSharpPower_Bin [15:8]

//	AFIT 1
	{0x0F12, 0x0000},	//AFIT16_BRIGHTNESS
	{0x0F12, 0x0000},	//AFIT16_CONTRAST
	{0x0F12, 0x0009},	//AFIT16_SATURATION
	{0x0F12, 0x0000},	//AFIT16_SHARP_BLUR
	{0x0F12, 0x0000},	//AFIT16_GLAMOUR
	{0x0F12, 0x0050},	//AFIT16_EE_iFlatBoundary
	{0x0F12, 0x0020},	//AFIT16_Yuvemix_mNegRanges_0
	{0x0F12, 0x0050},	//AFIT16_Yuvemix_mNegRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mNegRanges_2
	{0x0F12, 0x0008},	//AFIT16_Yuvemix_mPosRanges_0
	{0x0F12, 0x0020},	//AFIT16_Yuvemix_mPosRanges_1
	{0x0F12, 0x0050},	//AFIT16_Yuvemix_mPosRanges_2
	{0x0F12, 0x2F18},	//AFIT8_Dspcl_edge_low [7:0] AFIT8_Dspcl_edge_high [15:8]
	{0x0F12, 0x001A},	//AFIT8_Dspcl_repl_thresh [7:0] AFIT8_Dspcl_iConnectedThresh [15:8]
	{0x0F12, 0x3C24},	//AFIT8_Dspcl_iPlainLevel [7:0] AFIT8_Dspcl_iSatThresh [15:8]
	{0x0F12, 0x0C01},	//AFIT8_Dspcl_iPlainReference_H [7:0] AFIT8_Dspcl_iVarianceMultThresh_H [15:8]
	{0x0F12, 0x100C},	//AFIT8_Dspcl_iVariancePlainMax_H [7:0] AFIT8_Dspcl_iVarianceLimitMax_H [15:8]
	{0x0F12, 0x0101},	//AFIT8_Dspcl_nClustLevel_C [7:0] AFIT8_Dspcl_iPlainReference_C [15:8]
	{0x0F12, 0x0C0C},	//AFIT8_Dspcl_iVarianceMultThresh_C [7:0] AFIT8_Dspcl_iVariancePlainMax_C [15:8]
	{0x0F12, 0x3010},	//AFIT8_Dspcl_iVarianceLimitMax_C [7:0] AFIT8_EE_iShVLowRegion [15:8]
	{0x0F12, 0x100C},	//AFIT8_EE_iFSmagPosPwrLow [7:0] AFIT8_EE_iFSmagPosPwrHigh [15:8]
	{0x0F12, 0x1410},	//AFIT8_EE_iFSmagNegPwrLow [7:0] AFIT8_EE_iFSmagNegPwrHigh [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iFSThLow [7:0] AFIT8_EE_iFSThHigh [15:8]
	{0x0F12, 0x0A04},	//AFIT8_EE_iXformTh_High [7:0] AFIT8_EE_iXformTh_Low [15:8]
	{0x0F12, 0x0A0C},	//AFIT8_EE_iVLowFSmagPower [7:0] AFIT8_EE_iVLowiXformTh [15:8]
	{0x0F12, 0x0510},	//AFIT8_EE_iReduceNoiseRatio [7:0] AFIT8_EE_iFlatSpan [15:8]
	{0x0F12, 0x1408},	//AFIT8_EE_iMSharpenLow [7:0] AFIT8_EE_iMSharpenHigh [15:8]
	{0x0F12, 0x183C},	//AFIT8_EE_iFlatMean [7:0] AFIT8_EE_iFlatOffset [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iMShThLow [7:0] AFIT8_EE_iMShThHigh [15:8]
	{0x0F12, 0x0406},	//AFIT8_EE_iMShDirThLow [7:0] AFIT8_EE_iMShDirThHigh [15:8]
	{0x0F12, 0x0608},	//AFIT8_EE_iMShVLowPwr [7:0] AFIT8_EE_iMShVLowThrld [15:8]
	{0x0F12, 0x140C},	//AFIT8_EE_iWSharpenPosLow [7:0] AFIT8_EE_iWSharpenPosHigh [15:8]
	{0x0F12, 0x180C},	//AFIT8_EE_iWSharpenNegLow [7:0] AFIT8_EE_iWSharpenNegHigh [15:8]
	{0x0F12, 0x0204},	//AFIT8_EE_iWShThLow [7:0] AFIT8_EE_iWShThHigh [15:8]
	{0x0F12, 0x040C},	//AFIT8_EE_iWShVLowPwr [7:0] AFIT8_EE_iWShVLowThrld [15:8]
	{0x0F12, 0x5A00},	//AFIT8_EE_iReduceNegative [7:0] AFIT8_EE_iRadialLimitSh [15:8]
	{0x0F12, 0x4003},	//AFIT8_EE_iRadialPowerSh [7:0] AFIT8_Bdns_iDispTH_L [15:8]
	{0x0F12, 0x0440},	//AFIT8_Bdns_iDispTH_H [7:0] AFIT8_Bdns_iDispLimit_L [15:8]
	{0x0F12, 0x0A04},	//AFIT8_Bdns_iDispLimit_H [7:0] AFIT8_Bdns_iDispTH4HF [15:8]
	{0x0F12, 0x0101},	//AFIT8_Bdns_iDispLimit4HF_L [7:0] AFIT8_Bdns_iDispLimit4HF_H [15:8]
	{0x0F12, 0x1E28},	//AFIT8_Bdns_iDenoiseTH_G_L [7:0] AFIT8_Bdns_iDenoiseTH_G_H [15:8]
	{0x0F12, 0x1E28},	//AFIT8_Bdns_iDenoiseTH_NG_L [7:0] AFIT8_Bdns_iDenoiseTH_NG_H [15:8]
	{0x0F12, 0x0500},	//AFIT8_Bdns_iDistSigmaMin [7:0] AFIT8_Bdns_iDistSigmaMax [15:8]
	{0x0F12, 0x3C3C},	//AFIT8_Bdns_iDenoiseTH_Add_Plain [7:0] AFIT8_Bdns_iDenoiseTH_Add_Direc [15:8]
	{0x0F12, 0x3204},	//AFIT8_Bdns_iDirConfidenceMin [7:0] AFIT8_Bdns_iDirConfidenceMax [15:8]
	{0x0F12, 0x5008},	//AFIT8_Bdns_iPatternTH_MIN [7:0] AFIT8_Bdns_iPatternTH_MAX [15:8]
	{0x0F12, 0x2000},	//AFIT8_Bdns_iNRTune [7:0] AFIT8_Bdns_iLowMaxSlopeAllowed [15:8]
	{0x0F12, 0x5A20},	//AFIT8_Bdns_iHighMaxSlopeAllowed [7:0] AFIT8_Bdns_iRadialLimitNR [15:8]
	{0x0F12, 0x0C04},	//AFIT8_Bdns_iRadialPowerNR [7:0] AFIT8_Dmsc_iEnhThresh [15:8]
	{0x0F12, 0x0F08},	//AFIT8_Dmsc_iDesatThresh [7:0] AFIT8_Dmsc_iDemBlurLow [15:8]
	{0x0F12, 0x050F},	//AFIT8_Dmsc_iDemBlurHigh [7:0] AFIT8_Dmsc_iDemBlurRange [15:8]
	{0x0F12, 0x8006},	//AFIT8_Dmsc_iDecisionThresh [7:0] AFIT8_Dmsc_iCentGrad [15:8]
	{0x0F12, 0x0020},	//AFIT8_Dmsc_iMonochrom [7:0] AFIT8_Dmsc_iGRDenoiseVal [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iGBDenoiseVal [7:0] AFIT8_Dmsc_iEdgeDesatThrLow [15:8]
	{0x0F12, 0x1800},	//AFIT8_Dmsc_iEdgeDesatThrHigh [7:0] AFIT8_Dmsc_iEdgeDesat [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iEdgeDesatLimit [7:0] AFIT8_Dmsc_iNearGrayDesat [15:8]
	{0x0F12, 0xE119},	//AFIT8_Postdmsc_iLowBright [7:0] AFIT8_Postdmsc_iHighBright [15:8]
	{0x0F12, 0x7D0D},	//AFIT8_Postdmsc_iLowSat [7:0] AFIT8_Postdmsc_iHighSat [15:8]
	{0x0F12, 0x1E10},	//AFIT8_Postdmsc_iBCoeff [7:0] AFIT8_Postdmsc_iGCoeff [15:8]
	{0x0F12, 0x1C0B},	//AFIT8_Postdmsc_iWideMult [7:0] AFIT8_Postdmsc_iTune [15:8]
	{0x0F12, 0x0A02},	//AFIT8_Postdmsc_NoisePower_Low [7:0] AFIT8_Postdmsc_NoisePower_High [15:8]
	{0x0F12, 0x0C04},	//AFIT8_Postdmsc_NoisePower_VLow [7:0] AFIT8_Postdmsc_NoiseLimit_Low [15:8]
	{0x0F12, 0x0A0C},	//AFIT8_Postdmsc_NoiseLimit_High [7:0] AFIT8_Postdmsc_iSkinNS [15:8]
	{0x0F12, 0x0308},	//AFIT8_Postdmsc_iReduceNS_EdgeTh [7:0] AFIT8_Postdmsc_iReduceNS_Slope [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mNegSlopes_0 [7:0] AFIT8_Yuvemix_mNegSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mNegSlopes_2 [7:0] AFIT8_Yuvemix_mNegSlopes_3 [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mPosSlopes_0 [7:0] AFIT8_Yuvemix_mPosSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mPosSlopes_2 [7:0] AFIT8_Yuvemix_mPosSlopes_3 [15:8]
	{0x0F12, 0x1414},	//AFIT8_Yuviirnr_iYThreshL [7:0] AFIT8_Yuviirnr_iYThreshH [15:8]
	{0x0F12, 0x1212},	//AFIT8_Yuviirnr_iYNRStrengthL [7:0] AFIT8_Yuviirnr_iYNRStrengthH [15:8]
	{0x0F12, 0x080C},	//AFIT8_Yuviirnr_iUVThreshL [7:0] AFIT8_Yuviirnr_iUVThreshH [15:8]
	{0x0F12, 0x0C10},	//AFIT8_Yuviirnr_iDiffThreshL_UV [7:0] AFIT8_Yuviirnr_iDiffThreshH_UV [15:8]
	{0x0F12, 0x0406},	//AFIT8_Yuviirnr_iMaxThreshL_UV [7:0] AFIT8_Yuviirnr_iMaxThreshH_UV [15:8]
	{0x0F12, 0x1F1F},	//AFIT8_Yuviirnr_iUVNRStrengthL [7:0] AFIT8_Yuviirnr_iUVNRStrengthH [15:8]
	{0x0F12, 0x8080},	//AFIT8_byr_gras_iShadingPower [7:0] AFIT8_RGBGamma2_iLinearity [15:8]
	{0x0F12, 0x8018},	//AFIT8_RGBGamma2_iDarkReduce [7:0] AFIT8_ccm_oscar_iSaturation [15:8]
	{0x0F12, 0x8000},	//AFIT8_RGB2YUV_iYOffset [7:0] AFIT8_RGB2YUV_iRGBGain [15:8]
	{0x0F12, 0x3001},	//AFIT8_Dspcl_nClustLevel_H [7:0] AFIT8_EE_iLowSharpPower [15:8]
	{0x0F12, 0x0140},	//AFIT8_EE_iHighSharpPower [7:0] AFIT8_Dspcl_nClustLevel_H_Bin [15:8]
	{0x0F12, 0x4030},	//AFIT8_EE_iLowSharpPower_Bin [7:0] AFIT8_EE_iHighSharpPower_Bin [15:8]

//	AFIT 2
	{0x0F12, 0x0000},	//AFIT16_BRIGHTNESS
	{0x0F12, 0x0000},	//AFIT16_CONTRAST
	{0x0F12, 0x000E},	//AFIT16_SATURATION
	{0x0F12, 0x0000},	//AFIT16_SHARP_BLUR
	{0x0F12, 0x0000},	//AFIT16_GLAMOUR
	{0x0F12, 0x0050},	//AFIT16_EE_iFlatBoundary
	{0x0F12, 0x0030},	//AFIT16_Yuvemix_mNegRanges_0
	{0x0F12, 0x0060},	//AFIT16_Yuvemix_mNegRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mNegRanges_2
	{0x0F12, 0x000C},	//AFIT16_Yuvemix_mPosRanges_0
	{0x0F12, 0x0030},	//AFIT16_Yuvemix_mPosRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mPosRanges_2
	{0x0F12, 0x2F18},	//AFIT8_Dspcl_edge_low [7:0] AFIT8_Dspcl_edge_high [15:8]
	{0x0F12, 0x0420},	//AFIT8_Dspcl_repl_thresh [7:0] AFIT8_Dspcl_iConnectedThresh [15:8]
	{0x0F12, 0x3C24},	//AFIT8_Dspcl_iPlainLevel [7:0] AFIT8_Dspcl_iSatThresh [15:8]
	{0x0F12, 0x0C01},	//AFIT8_Dspcl_iPlainReference_H [7:0] AFIT8_Dspcl_iVarianceMultThresh_H [15:8]
	{0x0F12, 0x100C},	//AFIT8_Dspcl_iVariancePlainMax_H [7:0] AFIT8_Dspcl_iVarianceLimitMax_H [15:8]
	{0x0F12, 0x0101},	//AFIT8_Dspcl_nClustLevel_C [7:0] AFIT8_Dspcl_iPlainReference_C [15:8]
	{0x0F12, 0x0C0C},	//AFIT8_Dspcl_iVarianceMultThresh_C [7:0] AFIT8_Dspcl_iVariancePlainMax_C [15:8]
	{0x0F12, 0x3010},	//AFIT8_Dspcl_iVarianceLimitMax_C [7:0] AFIT8_EE_iShVLowRegion [15:8]
	{0x0F12, 0x100C},	//AFIT8_EE_iFSmagPosPwrLow [7:0] AFIT8_EE_iFSmagPosPwrHigh [15:8]
	{0x0F12, 0x1410},	//AFIT8_EE_iFSmagNegPwrLow [7:0] AFIT8_EE_iFSmagNegPwrHigh [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iFSThLow [7:0] AFIT8_EE_iFSThHigh [15:8]
	{0x0F12, 0x0602},	//AFIT8_EE_iXformTh_High [7:0] AFIT8_EE_iXformTh_Low [15:8]
	{0x0F12, 0x060C},	//AFIT8_EE_iVLowFSmagPower [7:0] AFIT8_EE_iVLowiXformTh [15:8]
	{0x0F12, 0x0510},	//AFIT8_EE_iReduceNoiseRatio [7:0] AFIT8_EE_iFlatSpan [15:8]
	{0x0F12, 0x180C},	//AFIT8_EE_iMSharpenLow [7:0] AFIT8_EE_iMSharpenHigh [15:8]
	{0x0F12, 0x0101},	//AFIT8_EE_iFlatMean [7:0] AFIT8_EE_iFlatOffset [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iMShThLow [7:0] AFIT8_EE_iMShThHigh [15:8]
	{0x0F12, 0x0408},	//AFIT8_EE_iMShDirThLow [7:0] AFIT8_EE_iMShDirThHigh [15:8]
	{0x0F12, 0x0808},	//AFIT8_EE_iMShVLowPwr [7:0] AFIT8_EE_iMShVLowThrld [15:8]
	{0x0F12, 0x1410},	//AFIT8_EE_iWSharpenPosLow [7:0] AFIT8_EE_iWSharpenPosHigh [15:8]
	{0x0F12, 0x2010},	//AFIT8_EE_iWSharpenNegLow [7:0] AFIT8_EE_iWSharpenNegHigh [15:8]
	{0x0F12, 0x0204},	//AFIT8_EE_iWShThLow [7:0] AFIT8_EE_iWShThHigh [15:8]
	{0x0F12, 0x040C},	//AFIT8_EE_iWShVLowPwr [7:0] AFIT8_EE_iWShVLowThrld [15:8]
	{0x0F12, 0x5A00},	//AFIT8_EE_iReduceNegative [7:0] AFIT8_EE_iRadialLimitSh [15:8]
	{0x0F12, 0x4002},	//AFIT8_EE_iRadialPowerSh [7:0] AFIT8_Bdns_iDispTH_L [15:8]
	{0x0F12, 0x0440},	//AFIT8_Bdns_iDispTH_H [7:0] AFIT8_Bdns_iDispLimit_L [15:8]
	{0x0F12, 0x0A04},	//AFIT8_Bdns_iDispLimit_H [7:0] AFIT8_Bdns_iDispTH4HF [15:8]
	{0x0F12, 0x0101},	//AFIT8_Bdns_iDispLimit4HF_L [7:0] AFIT8_Bdns_iDispLimit4HF_H [15:8]
	{0x0F12, 0x1824},	//AFIT8_Bdns_iDenoiseTH_G_L [7:0] AFIT8_Bdns_iDenoiseTH_G_H [15:8]
	{0x0F12, 0x1824},	//AFIT8_Bdns_iDenoiseTH_NG_L [7:0] AFIT8_Bdns_iDenoiseTH_NG_H [15:8]
	{0x0F12, 0x0500},	//AFIT8_Bdns_iDistSigmaMin [7:0] AFIT8_Bdns_iDistSigmaMax [15:8]
	{0x0F12, 0x3C3C},	//AFIT8_Bdns_iDenoiseTH_Add_Plain [7:0] AFIT8_Bdns_iDenoiseTH_Add_Direc [15:8]
	{0x0F12, 0x1E04},	//AFIT8_Bdns_iDirConfidenceMin [7:0] AFIT8_Bdns_iDirConfidenceMax [15:8]
	{0x0F12, 0x2808},	//AFIT8_Bdns_iPatternTH_MIN [7:0] AFIT8_Bdns_iPatternTH_MAX [15:8]
	{0x0F12, 0x2000},	//AFIT8_Bdns_iNRTune [7:0] AFIT8_Bdns_iLowMaxSlopeAllowed [15:8]
	{0x0F12, 0x5A20},	//AFIT8_Bdns_iHighMaxSlopeAllowed [7:0] AFIT8_Bdns_iRadialLimitNR [15:8]
	{0x0F12, 0x0C02},	//AFIT8_Bdns_iRadialPowerNR [7:0] AFIT8_Dmsc_iEnhThresh [15:8]
	{0x0F12, 0x0F08},	//AFIT8_Dmsc_iDesatThresh [7:0] AFIT8_Dmsc_iDemBlurLow [15:8]
	{0x0F12, 0x050F},	//AFIT8_Dmsc_iDemBlurHigh [7:0] AFIT8_Dmsc_iDemBlurRange [15:8]
	{0x0F12, 0x8006},	//AFIT8_Dmsc_iDecisionThresh [7:0] AFIT8_Dmsc_iCentGrad [15:8]
	{0x0F12, 0x0020},	//AFIT8_Dmsc_iMonochrom [7:0] AFIT8_Dmsc_iGRDenoiseVal [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iGBDenoiseVal [7:0] AFIT8_Dmsc_iEdgeDesatThrLow [15:8]
	{0x0F12, 0x1800},	//AFIT8_Dmsc_iEdgeDesatThrHigh [7:0] AFIT8_Dmsc_iEdgeDesat [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iEdgeDesatLimit [7:0] AFIT8_Dmsc_iNearGrayDesat [15:8]
	{0x0F12, 0xE119},	//AFIT8_Postdmsc_iLowBright [7:0] AFIT8_Postdmsc_iHighBright [15:8]
	{0x0F12, 0x7D0D},	//AFIT8_Postdmsc_iLowSat [7:0] AFIT8_Postdmsc_iHighSat [15:8]
	{0x0F12, 0x1E10},	//AFIT8_Postdmsc_iBCoeff [7:0] AFIT8_Postdmsc_iGCoeff [15:8]
	{0x0F12, 0x1C0B},	//AFIT8_Postdmsc_iWideMult [7:0] AFIT8_Postdmsc_iTune [15:8]
	{0x0F12, 0x0C04},	//AFIT8_Postdmsc_NoisePower_Low [7:0] AFIT8_Postdmsc_NoisePower_High [15:8]
	{0x0F12, 0x1004},	//AFIT8_Postdmsc_NoisePower_VLow [7:0] AFIT8_Postdmsc_NoiseLimit_Low [15:8]
	{0x0F12, 0x0A10},	//AFIT8_Postdmsc_NoiseLimit_High [7:0] AFIT8_Postdmsc_iSkinNS [15:8]
	{0x0F12, 0x0308},	//AFIT8_Postdmsc_iReduceNS_EdgeTh [7:0] AFIT8_Postdmsc_iReduceNS_Slope [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mNegSlopes_0 [7:0] AFIT8_Yuvemix_mNegSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mNegSlopes_2 [7:0] AFIT8_Yuvemix_mNegSlopes_3 [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mPosSlopes_0 [7:0] AFIT8_Yuvemix_mPosSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mPosSlopes_2 [7:0] AFIT8_Yuvemix_mPosSlopes_3 [15:8]
	{0x0F12, 0x1414},	//AFIT8_Yuviirnr_iYThreshL [7:0] AFIT8_Yuviirnr_iYThreshH [15:8]
	{0x0F12, 0x0C0C},	//AFIT8_Yuviirnr_iYNRStrengthL [7:0] AFIT8_Yuviirnr_iYNRStrengthH [15:8]
	{0x0F12, 0x080A},	//AFIT8_Yuviirnr_iUVThreshL [7:0] AFIT8_Yuviirnr_iUVThreshH [15:8]
	{0x0F12, 0x0C10},	//AFIT8_Yuviirnr_iDiffThreshL_UV [7:0] AFIT8_Yuviirnr_iDiffThreshH_UV [15:8]
	{0x0F12, 0x0406},	//AFIT8_Yuviirnr_iMaxThreshL_UV [7:0] AFIT8_Yuviirnr_iMaxThreshH_UV [15:8]
	{0x0F12, 0x1C1F},	//AFIT8_Yuviirnr_iUVNRStrengthL [7:0] AFIT8_Yuviirnr_iUVNRStrengthH [15:8]
	{0x0F12, 0x8080},	//AFIT8_byr_gras_iShadingPower [7:0] AFIT8_RGBGamma2_iLinearity [15:8]
	{0x0F12, 0x8018},	//AFIT8_RGBGamma2_iDarkReduce [7:0] AFIT8_ccm_oscar_iSaturation [15:8]
	{0x0F12, 0x8000},	//AFIT8_RGB2YUV_iYOffset [7:0] AFIT8_RGB2YUV_iRGBGain [15:8]
	{0x0F12, 0x3601},	//AFIT8_Dspcl_nClustLevel_H [7:0] AFIT8_EE_iLowSharpPower [15:8]
	{0x0F12, 0x0178},	//AFIT8_EE_iHighSharpPower [7:0] AFIT8_Dspcl_nClustLevel_H_Bin [15:8]
	{0x0F12, 0x4636},	//AFIT8_EE_iLowSharpPower_Bin [7:0] AFIT8_EE_iHighSharpPower_Bin [15:8]

//	AFIT 3
	{0x0F12, 0x0000},	//AFIT16_BRIGHTNESS
	{0x0F12, 0x0000},	//AFIT16_CONTRAST
	{0x0F12, 0x000D},	//AFIT16_SATURATION
	{0x0F12, 0x0000},	//AFIT16_SHARP_BLUR
	{0x0F12, 0x0000},	//AFIT16_GLAMOUR
	{0x0F12, 0x0050},	//AFIT16_EE_iFlatBoundary
	{0x0F12, 0x0030},	//AFIT16_Yuvemix_mNegRanges_0
	{0x0F12, 0x0060},	//AFIT16_Yuvemix_mNegRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mNegRanges_2
	{0x0F12, 0x000C},	//AFIT16_Yuvemix_mPosRanges_0
	{0x0F12, 0x0030},	//AFIT16_Yuvemix_mPosRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mPosRanges_2
	{0x0F12, 0x2F18},	//AFIT8_Dspcl_edge_low [7:0] AFIT8_Dspcl_edge_high [15:8]
	{0x0F12, 0x0420},	//AFIT8_Dspcl_repl_thresh [7:0] AFIT8_Dspcl_iConnectedThresh [15:8]
	{0x0F12, 0x3C20},	//AFIT8_Dspcl_iPlainLevel [7:0] AFIT8_Dspcl_iSatThresh [15:8]
	{0x0F12, 0x0C01},	//AFIT8_Dspcl_iPlainReference_H [7:0] AFIT8_Dspcl_iVarianceMultThresh_H [15:8]
	{0x0F12, 0x100C},	//AFIT8_Dspcl_iVariancePlainMax_H [7:0] AFIT8_Dspcl_iVarianceLimitMax_H [15:8]
	{0x0F12, 0x0101},	//AFIT8_Dspcl_nClustLevel_C [7:0] AFIT8_Dspcl_iPlainReference_C [15:8]
	{0x0F12, 0x0C0C},	//AFIT8_Dspcl_iVarianceMultThresh_C [7:0] AFIT8_Dspcl_iVariancePlainMax_C [15:8]
	{0x0F12, 0x3010},	//AFIT8_Dspcl_iVarianceLimitMax_C [7:0] AFIT8_EE_iShVLowRegion [15:8]
	{0x0F12, 0x100C},	//AFIT8_EE_iFSmagPosPwrLow [7:0] AFIT8_EE_iFSmagPosPwrHigh [15:8]
	{0x0F12, 0x1810},	//AFIT8_EE_iFSmagNegPwrLow [7:0] AFIT8_EE_iFSmagNegPwrHigh [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iFSThLow [7:0] AFIT8_EE_iFSThHigh [15:8]
	{0x0F12, 0x0602},	//AFIT8_EE_iXformTh_High [7:0] AFIT8_EE_iXformTh_Low [15:8]
	{0x0F12, 0x060C},	//AFIT8_EE_iVLowFSmagPower [7:0] AFIT8_EE_iVLowiXformTh [15:8]
	{0x0F12, 0x0510},	//AFIT8_EE_iReduceNoiseRatio [7:0] AFIT8_EE_iFlatSpan [15:8]
	{0x0F12, 0x180C},	//AFIT8_EE_iMSharpenLow [7:0] AFIT8_EE_iMSharpenHigh [15:8]
	{0x0F12, 0x0101},	//AFIT8_EE_iFlatMean [7:0] AFIT8_EE_iFlatOffset [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iMShThLow [7:0] AFIT8_EE_iMShThHigh [15:8]
	{0x0F12, 0x0406},	//AFIT8_EE_iMShDirThLow [7:0] AFIT8_EE_iMShDirThHigh [15:8]
	{0x0F12, 0x0608},	//AFIT8_EE_iMShVLowPwr [7:0] AFIT8_EE_iMShVLowThrld [15:8]
	{0x0F12, 0x180C},	//AFIT8_EE_iWSharpenPosLow [7:0] AFIT8_EE_iWSharpenPosHigh [15:8]
	{0x0F12, 0x2010},	//AFIT8_EE_iWSharpenNegLow [7:0] AFIT8_EE_iWSharpenNegHigh [15:8]
	{0x0F12, 0x0204},	//AFIT8_EE_iWShThLow [7:0] AFIT8_EE_iWShThHigh [15:8]
	{0x0F12, 0x040C},	//AFIT8_EE_iWShVLowPwr [7:0] AFIT8_EE_iWShVLowThrld [15:8]
	{0x0F12, 0x5A00},	//AFIT8_EE_iReduceNegative [7:0] AFIT8_EE_iRadialLimitSh [15:8]
	{0x0F12, 0x4002},	//AFIT8_EE_iRadialPowerSh [7:0] AFIT8_Bdns_iDispTH_L [15:8]
	{0x0F12, 0x0440},	//AFIT8_Bdns_iDispTH_H [7:0] AFIT8_Bdns_iDispLimit_L [15:8]
	{0x0F12, 0x0A04},	//AFIT8_Bdns_iDispLimit_H [7:0] AFIT8_Bdns_iDispTH4HF [15:8]
	{0x0F12, 0x0101},	//AFIT8_Bdns_iDispLimit4HF_L [7:0] AFIT8_Bdns_iDispLimit4HF_H [15:8]
	{0x0F12, 0x1420},	//AFIT8_Bdns_iDenoiseTH_G_L [7:0] AFIT8_Bdns_iDenoiseTH_G_H [15:8]
	{0x0F12, 0x1420},	//AFIT8_Bdns_iDenoiseTH_NG_L [7:0] AFIT8_Bdns_iDenoiseTH_NG_H [15:8]
	{0x0F12, 0x0500},	//AFIT8_Bdns_iDistSigmaMin [7:0] AFIT8_Bdns_iDistSigmaMax [15:8]
	{0x0F12, 0x3C3C},	//AFIT8_Bdns_iDenoiseTH_Add_Plain [7:0] AFIT8_Bdns_iDenoiseTH_Add_Direc [15:8]
	{0x0F12, 0x1E04},	//AFIT8_Bdns_iDirConfidenceMin [7:0] AFIT8_Bdns_iDirConfidenceMax [15:8]
	{0x0F12, 0x2808},	//AFIT8_Bdns_iPatternTH_MIN [7:0] AFIT8_Bdns_iPatternTH_MAX [15:8]
	{0x0F12, 0x2000},	//AFIT8_Bdns_iNRTune [7:0] AFIT8_Bdns_iLowMaxSlopeAllowed [15:8]
	{0x0F12, 0x5A20},	//AFIT8_Bdns_iHighMaxSlopeAllowed [7:0] AFIT8_Bdns_iRadialLimitNR [15:8]
	{0x0F12, 0x0C02},	//AFIT8_Bdns_iRadialPowerNR [7:0] AFIT8_Dmsc_iEnhThresh [15:8]
	{0x0F12, 0x0F08},	//AFIT8_Dmsc_iDesatThresh [7:0] AFIT8_Dmsc_iDemBlurLow [15:8]
	{0x0F12, 0x050F},	//AFIT8_Dmsc_iDemBlurHigh [7:0] AFIT8_Dmsc_iDemBlurRange [15:8]
	{0x0F12, 0x8006},	//AFIT8_Dmsc_iDecisionThresh [7:0] AFIT8_Dmsc_iCentGrad [15:8]
	{0x0F12, 0x0020},	//AFIT8_Dmsc_iMonochrom [7:0] AFIT8_Dmsc_iGRDenoiseVal [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iGBDenoiseVal [7:0] AFIT8_Dmsc_iEdgeDesatThrLow [15:8]
	{0x0F12, 0x1E00},	//AFIT8_Dmsc_iEdgeDesatThrHigh [7:0] AFIT8_Dmsc_iEdgeDesat [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iEdgeDesatLimit [7:0] AFIT8_Dmsc_iNearGrayDesat [15:8]
	{0x0F12, 0xE119},	//AFIT8_Postdmsc_iLowBright [7:0] AFIT8_Postdmsc_iHighBright [15:8]
	{0x0F12, 0x7D0D},	//AFIT8_Postdmsc_iLowSat [7:0] AFIT8_Postdmsc_iHighSat [15:8]			#endif
	{0x0F12, 0x1E10},	//AFIT8_Postdmsc_iBCoeff [7:0] AFIT8_Postdmsc_iGCoeff [15:8]
	{0x0F12, 0x1C0B},	//AFIT8_Postdmsc_iWideMult [7:0] AFIT8_Postdmsc_iTune [15:8]
	{0x0F12, 0x0C08},	//AFIT8_Postdmsc_NoisePower_Low [7:0] AFIT8_Postdmsc_NoisePower_High [15:8]
	{0x0F12, 0x1406},	//AFIT8_Postdmsc_NoisePower_VLow [7:0] AFIT8_Postdmsc_NoiseLimit_Low [15:8]
	{0x0F12, 0x0A14},	//AFIT8_Postdmsc_NoiseLimit_High [7:0] AFIT8_Postdmsc_iSkinNS [15:8]
	{0x0F12, 0x0308},	//AFIT8_Postdmsc_iReduceNS_EdgeTh [7:0] AFIT8_Postdmsc_iReduceNS_Slope [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mNegSlopes_0 [7:0] AFIT8_Yuvemix_mNegSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mNegSlopes_2 [7:0] AFIT8_Yuvemix_mNegSlopes_3 [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mPosSlopes_0 [7:0] AFIT8_Yuvemix_mPosSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mPosSlopes_2 [7:0] AFIT8_Yuvemix_mPosSlopes_3 [15:8]
	{0x0F12, 0x1414},	//AFIT8_Yuviirnr_iYThreshL [7:0] AFIT8_Yuviirnr_iYThreshH [15:8]
	{0x0F12, 0x0C0C},	//AFIT8_Yuviirnr_iYNRStrengthL [7:0] AFIT8_Yuviirnr_iYNRStrengthH [15:8]
	{0x0F12, 0x080A},	//AFIT8_Yuviirnr_iUVThreshL [7:0] AFIT8_Yuviirnr_iUVThreshH [15:8]
	{0x0F12, 0x0C10},	//AFIT8_Yuviirnr_iDiffThreshL_UV [7:0] AFIT8_Yuviirnr_iDiffThreshH_UV [15:8]
	{0x0F12, 0x0406},	//AFIT8_Yuviirnr_iMaxThreshL_UV [7:0] AFIT8_Yuviirnr_iMaxThreshH_UV [15:8]
	{0x0F12, 0x1C1F},	//AFIT8_Yuviirnr_iUVNRStrengthL [7:0] AFIT8_Yuviirnr_iUVNRStrengthH [15:8]
	{0x0F12, 0x8080},	//AFIT8_byr_gras_iShadingPower [7:0] AFIT8_RGBGamma2_iLinearity [15:8]
	{0x0F12, 0x8018},	//AFIT8_RGBGamma2_iDarkReduce [7:0] AFIT8_ccm_oscar_iSaturation [15:8]
	{0x0F12, 0x8000},	//AFIT8_RGB2YUV_iYOffset [7:0] AFIT8_RGB2YUV_iRGBGain [15:8]
	{0x0F12, 0x4E01},	//0x4E01//AFIT8_Dspcl_nClustLevel_H [7:0] AFIT8_EE_iLowSharpPower [15:8]
	{0x0F12, 0x0181},	//0x0181//AFIT8_EE_iHighSharpPower [7:0] AFIT8_Dspcl_nClustLevel_H_Bin [15:8]
	{0x0F12, 0x463A},	//AFIT8_EE_iLowSharpPower_Bin [7:0] AFIT8_EE_iHighSharpPower_Bin [15:8]

//	AFIT 4
	{0x0F12, 0x0011},	//AFIT16_BRIGHTNESS
	{0x0F12, 0x0000},	//AFIT16_CONTRAST
	{0x0F12, 0x0008},	//AFIT16_SATURATION
	{0x0F12, 0x0000},	//AFIT16_SHARP_BLUR
	{0x0F12, 0x0000},	//AFIT16_GLAMOUR
	{0x0F12, 0x003C},	//AFIT16_EE_iFlatBoundary
	{0x0F12, 0x0030},	//AFIT16_Yuvemix_mNegRanges_0
	{0x0F12, 0x0060},	//AFIT16_Yuvemix_mNegRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mNegRanges_2
	{0x0F12, 0x000C},	//AFIT16_Yuvemix_mPosRanges_0
	{0x0F12, 0x0030},	//AFIT16_Yuvemix_mPosRanges_1
	{0x0F12, 0x0080},	//AFIT16_Yuvemix_mPosRanges_2
	{0x0F12, 0x2F18},	//AFIT8_Dspcl_edge_low [7:0] AFIT8_Dspcl_edge_high [15:8]
	{0x0F12, 0x0420},	//AFIT8_Dspcl_repl_thresh [7:0] AFIT8_Dspcl_iConnectedThresh [15:8]
	{0x0F12, 0x3C20},	//AFIT8_Dspcl_iPlainLevel [7:0] AFIT8_Dspcl_iSatThresh [15:8]
	{0x0F12, 0x0C01},	//AFIT8_Dspcl_iPlainReference_H [7:0] AFIT8_Dspcl_iVarianceMultThresh_H [15:8]
	{0x0F12, 0x100C},	//AFIT8_Dspcl_iVariancePlainMax_H [7:0] AFIT8_Dspcl_iVarianceLimitMax_H [15:8]
	{0x0F12, 0x0101},	//AFIT8_Dspcl_nClustLevel_C [7:0] AFIT8_Dspcl_iPlainReference_C [15:8]
	{0x0F12, 0x0C0C},	//AFIT8_Dspcl_iVarianceMultThresh_C [7:0] AFIT8_Dspcl_iVariancePlainMax_C [15:8]
	{0x0F12, 0x3010},	//AFIT8_Dspcl_iVarianceLimitMax_C [7:0] AFIT8_EE_iShVLowRegion [15:8]
	{0x0F12, 0x180C},	//AFIT8_EE_iFSmagPosPwrLow [7:0] AFIT8_EE_iFSmagPosPwrHigh [15:8]
	{0x0F12, 0x1810},	//AFIT8_EE_iFSmagNegPwrLow [7:0] AFIT8_EE_iFSmagNegPwrHigh [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iFSThLow [7:0] AFIT8_EE_iFSThHigh [15:8]
	{0x0F12, 0x0402},	//AFIT8_EE_iXformTh_High [7:0] AFIT8_EE_iXformTh_Low [15:8]
	{0x0F12, 0x040C},	//AFIT8_EE_iVLowFSmagPower [7:0] AFIT8_EE_iVLowiXformTh [15:8]
	{0x0F12, 0x050C},	//AFIT8_EE_iReduceNoiseRatio [7:0] AFIT8_EE_iFlatSpan [15:8]
	{0x0F12, 0x1E14},	//AFIT8_EE_iMSharpenLow [7:0] AFIT8_EE_iMSharpenHigh [15:8]
	{0x0F12, 0x0101},	//AFIT8_EE_iFlatMean [7:0] AFIT8_EE_iFlatOffset [15:8]
	{0x0F12, 0x0000},	//AFIT8_EE_iMShThLow [7:0] AFIT8_EE_iMShThHigh [15:8]
	{0x0F12, 0x0205},	//AFIT8_EE_iMShDirThLow [7:0] AFIT8_EE_iMShDirThHigh [15:8]
	{0x0F12, 0x050C},	//AFIT8_EE_iMShVLowPwr [7:0] AFIT8_EE_iMShVLowThrld [15:8]
	{0x0F12, 0x2623},	//AFIT8_EE_iWSharpenPosLow [7:0] AFIT8_EE_iWSharpenPosHigh [15:8]
	{0x0F12, 0x2619},	//AFIT8_EE_iWSharpenNegLow [7:0] AFIT8_EE_iWSharpenNegHigh [15:8]
	{0x0F12, 0x0102},	//AFIT8_EE_iWShThLow [7:0] AFIT8_EE_iWShThHigh [15:8]
	{0x0F12, 0x0210},	//AFIT8_EE_iWShVLowPwr [7:0] AFIT8_EE_iWShVLowThrld [15:8]
	{0x0F12, 0x5A00},	//AFIT8_EE_iReduceNegative [7:0] AFIT8_EE_iRadialLimitSh [15:8]
	{0x0F12, 0x4001},	//AFIT8_EE_iRadialPowerSh [7:0] AFIT8_Bdns_iDispTH_L [15:8]
	{0x0F12, 0x0240},	//AFIT8_Bdns_iDispTH_H [7:0] AFIT8_Bdns_iDispLimit_L [15:8]
	{0x0F12, 0x0402},	//AFIT8_Bdns_iDispLimit_H [7:0] AFIT8_Bdns_iDispTH4HF [15:8]
	{0x0F12, 0x0000},	//AFIT8_Bdns_iDispLimit4HF_L [7:0] AFIT8_Bdns_iDispLimit4HF_H [15:8]
	{0x0F12, 0x0C18},	//AFIT8_Bdns_iDenoiseTH_G_L [7:0] AFIT8_Bdns_iDenoiseTH_G_H [15:8]
	{0x0F12, 0x0C18},	//AFIT8_Bdns_iDenoiseTH_NG_L [7:0] AFIT8_Bdns_iDenoiseTH_NG_H [15:8]
	{0x0F12, 0x0300},	//AFIT8_Bdns_iDistSigmaMin [7:0] AFIT8_Bdns_iDistSigmaMax [15:8]
	{0x0F12, 0x3C32},	//AFIT8_Bdns_iDenoiseTH_Add_Plain [7:0] AFIT8_Bdns_iDenoiseTH_Add_Direc [15:8]
	{0x0F12, 0x2802},	//AFIT8_Bdns_iDirConfidenceMin [7:0] AFIT8_Bdns_iDirConfidenceMax [15:8]
	{0x0F12, 0x2806},	//AFIT8_Bdns_iPatternTH_MIN [7:0] AFIT8_Bdns_iPatternTH_MAX [15:8]
	{0x0F12, 0x1000},	//AFIT8_Bdns_iNRTune [7:0] AFIT8_Bdns_iLowMaxSlopeAllowed [15:8]
	{0x0F12, 0x5A10},	//AFIT8_Bdns_iHighMaxSlopeAllowed [7:0] AFIT8_Bdns_iRadialLimitNR [15:8]
	{0x0F12, 0x0801},	//AFIT8_Bdns_iRadialPowerNR [7:0] AFIT8_Dmsc_iEnhThresh [15:8]
	{0x0F12, 0x0808},	//AFIT8_Dmsc_iDesatThresh [7:0] AFIT8_Dmsc_iDemBlurLow [15:8]
	{0x0F12, 0x0508},	//AFIT8_Dmsc_iDemBlurHigh [7:0] AFIT8_Dmsc_iDemBlurRange [15:8]
	{0x0F12, 0x8006},	//AFIT8_Dmsc_iDecisionThresh [7:0] AFIT8_Dmsc_iCentGrad [15:8]
	{0x0F12, 0x0020},	//AFIT8_Dmsc_iMonochrom [7:0] AFIT8_Dmsc_iGRDenoiseVal [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iGBDenoiseVal [7:0] AFIT8_Dmsc_iEdgeDesatThrLow [15:8]
	{0x0F12, 0x1400},	//AFIT8_Dmsc_iEdgeDesatThrHigh [7:0] AFIT8_Dmsc_iEdgeDesat [15:8]
	{0x0F12, 0x0000},	//AFIT8_Dmsc_iEdgeDesatLimit [7:0] AFIT8_Dmsc_iNearGrayDesat [15:8]
	{0x0F12, 0xE119},	//AFIT8_Postdmsc_iLowBright [7:0] AFIT8_Postdmsc_iHighBright [15:8]
	{0x0F12, 0x7D0D},	//AFIT8_Postdmsc_iLowSat [7:0] AFIT8_Postdmsc_iHighSat [15:8]
	{0x0F12, 0x1E10},	//AFIT8_Postdmsc_iBCoeff [7:0] AFIT8_Postdmsc_iGCoeff [15:8]
	{0x0F12, 0x1C0B},	//AFIT8_Postdmsc_iWideMult [7:0] AFIT8_Postdmsc_iTune [15:8]
	{0x0F12, 0x1008},	//AFIT8_Postdmsc_NoisePower_Low [7:0] AFIT8_Postdmsc_NoisePower_High [15:8]
	{0x0F12, 0x1408},	//AFIT8_Postdmsc_NoisePower_VLow [7:0] AFIT8_Postdmsc_NoiseLimit_Low [15:8]
	{0x0F12, 0x0A14},	//AFIT8_Postdmsc_NoiseLimit_High [7:0] AFIT8_Postdmsc_iSkinNS [15:8]
	{0x0F12, 0x0308},	//AFIT8_Postdmsc_iReduceNS_EdgeTh [7:0] AFIT8_Postdmsc_iReduceNS_Slope [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mNegSlopes_0 [7:0] AFIT8_Yuvemix_mNegSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mNegSlopes_2 [7:0] AFIT8_Yuvemix_mNegSlopes_3 [15:8]
	{0x0F12, 0x0700},	//AFIT8_Yuvemix_mPosSlopes_0 [7:0] AFIT8_Yuvemix_mPosSlopes_1 [15:8]
	{0x0F12, 0x0506},	//AFIT8_Yuvemix_mPosSlopes_2 [7:0] AFIT8_Yuvemix_mPosSlopes_3 [15:8]
	{0x0F12, 0x1010},	//AFIT8_Yuviirnr_iYThreshL [7:0] AFIT8_Yuviirnr_iYThreshH [15:8]
	{0x0F12, 0x0808},	//AFIT8_Yuviirnr_iYNRStrengthL [7:0] AFIT8_Yuviirnr_iYNRStrengthH [15:8]
	{0x0F12, 0x080A},	//AFIT8_Yuviirnr_iUVThreshL [7:0] AFIT8_Yuviirnr_iUVThreshH [15:8]
	{0x0F12, 0x080C},	//AFIT8_Yuviirnr_iDiffThreshL_UV [7:0] AFIT8_Yuviirnr_iDiffThreshH_UV [15:8]
	{0x0F12, 0x0406},	//AFIT8_Yuviirnr_iMaxThreshL_UV [7:0] AFIT8_Yuviirnr_iMaxThreshH_UV [15:8]
	{0x0F12, 0x1C1F},	//AFIT8_Yuviirnr_iUVNRStrengthL [7:0] AFIT8_Yuviirnr_iUVNRStrengthH [15:8]
	{0x0F12, 0x8080},	//AFIT8_byr_gras_iShadingPower [7:0] AFIT8_RGBGamma2_iLinearity [15:8]
	{0x0F12, 0x8000},	//AFIT8_RGBGamma2_iDarkReduce [7:0] AFIT8_ccm_oscar_iSaturation [15:8]
	{0x0F12, 0x8000},	//AFIT8_RGB2YUV_iYOffset [7:0] AFIT8_RGB2YUV_iRGBGain [15:8]
	{0x0F12, 0x5801},	//AFIT8_Dspcl_nClustLevel_H [7:0] AFIT8_EE_iLowSharpPower [15:8]
	{0x0F12, 0x01A0},	//AFIT8_EE_iHighSharpPower [7:0] AFIT8_Dspcl_nClustLevel_H_Bin [15:8]
	{0x0F12, 0x8C40},	//AFIT8_EE_iLowSharpPower_Bin [7:0] AFIT8_EE_iHighSharpPower_Bin [15:8]

//	CAFIT
	{0x0F12, 0xFFEE},	//[0]CAFITB_Dspcl_bypass
	{0x0F12, 0x3376},	//[0]CAFITB_EE_bReduceNegative
	{0x0F12, 0xBC3F},	//[0]CAFITB_Dmsc_bEnhThresh
	{0x0F12, 0x0337},	//[0]CAFITB_Postdmsc_bNoiseLimit

//=====================================================
// 15.Clock Setting
//=====================================================
	{0x002A, 0x01E4},
	{0x0F12, 0x5DC0},

	{0x002A, 0x0200},
	{0x0F12, 0x0002},

	{0x0F12, 0x0006},   //67Mhz
	{0x0F12, 0x0086},
	{0x0F12, 0x0000},
	{0x0F12, 0x0005},
	{0x0F12, 0x0004},
	{0x002A, 0x0214},
	{0x0F12, 0x0002},

	{0x0F12, 0x0006},	//81Mhz
	{0x0F12, 0x00A2},
	{0x0F12, 0x0000},
	{0x0F12, 0x0006},
	{0x0F12, 0x0004},
	{0x002A, 0x0228},
	{0x0F12, 0x0002},

//=====================================================
// 16.JPEG Thumnail Setting
//=====================================================

	{0x002A, 0x04B4},
	{0x0F12, 0x005F},   //REG_TC_BRC_usPrevQuality
	{0x0F12, 0x005F},   //REG_TC_BRC_usCaptureQuality

// JPEG Thumnail
	{0x0F12, 0x0001},	//REG_TC_THUMB_Thumb_bActive
	{0x0F12, 0x0280},	//REG_TC_THUMB_Thumb_uWidth
	{0x0F12, 0x01E0},	//REG_TC_THUMB_Thumb_uHeight
	{0x0F12, 0x0005},	//REG_TC_THUMB_Thumb_Format

	{0x002A, 0x12C8},
	{0x0F12, 0x0054},	//jpeg_ManualMBCV
	{0x002A, 0x0D24},
	{0x0F12, 0x001C},	//senHal_bExtraAddLine
	{0x002A, 0x02BE},
	{0x0F12, 0x0001},	//REG_TC_GP_bBypassScalerJpg
	{0x002A, 0x02C4},
	{0x0F12, 0x0000},	//REG_TC_GP_bUse1FrameCaptureMode

//======================================================
// 17.Input Size Setting
//======================================================
//Input Size
	{0x002A, 0x028A},
	{0x0F12, 0x0A00},  //REG_TC_GP_PrevReqInputWidth
	{0x0F12, 0x0780},  //REG_TC_GP_PrevReqInputHeight

	{0x002A, 0x0292},
	{0x0F12, 0x0A00},	//REG_TC_GP_CapReqInputWidth
	{0x0F12, 0x0780},	//REG_TC_GP_CapReqInputHeight

	{0x002A, 0x029C},
	{0x0F12, 0x0001},	//REG_TC_GP_bUseReqInputInPre
	{0x0F12, 0x0001},	//REG_TC_GP_bUseReqInputInCap

	{0x002A, 0x04D0},
	{0x0F12, 0x0A00},	//REG_TC_PZOOM_PrevZoomReqInputWidth
	{0x0F12, 0x0780},	//REG_TC_PZOOM_PrevZoomReqInputHeight
	{0x0F12, 0x0000},	//REG_TC_PZOOM_PrevZoomReqInputWidthOfs
	{0x0F12, 0x0000},	//REG_TC_PZOOM_PrevZoomReqInputHeightOfs
	{0x0F12, 0x0A00},	//REG_TC_PZOOM_CapZoomReqInputWidth
	{0x0F12, 0x0780},	//REG_TC_PZOOM_CapZoomReqInputHeight
	{0x0F12, 0x0000},	//REG_TC_PZOOM_CapZoomReqInputWidthOfs
	{0x0F12, 0x0000},	//REG_TC_PZOOM_CapZoomReqInputHeightOfs


//======================================================
// 18.Preview & Capture Configration Setting
//======================================================
//	Preview config[0]
//	81MHz, 1280x960, Dynamic 15 ~ 30fps
	{0x002A, 0x02E2},	//REG_PrevConfigControls_0_
	{0x0F12,   1280},	//REG_0TC_PCFG_usWidth		1280
	{0x0F12,    960},	//REG_0TC_PCFG_usHeight		960
	{0x0F12, 0x0005},   //REG_0TC_PCFG_Format		YUV
	{0x002A, 0x02EC},
	{0x0F12, 0x0100},   //REG_0TC_PCFG_OutClkPerPix88
	{0x0F12, 0x0300},   //REG_0TC_PCFG_uBpp88
	{0x0F12, 0x0050},   //REG_0TC_PCFG_PVIMask
	{0x0F12, 0x0000},   //REG_0TC_PCFG_OIFMask
	{0x0F12, 0x01E0},   //REG_0TC_PCFG_usJpegPacketSize
	{0x0F12, 0x0000},   //REG_0TC_PCFG_usJpegTotalPackets
	{0x0F12, 0x0001},   //REG_0TC_PCFG_uClockInd (1 : 81MHz)
	{0x0F12, 0x0002},   //0: Dynamic, 1: Not Accurate, 2: Fixed
	{0x0F12, 0x0001},   //0: Dynamic  1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, FRTIME_30},	//REG_0TC_PCFG_usMaxFrTimeMsecMult10
	{0x0F12, FRTIME_30},	//REG_0TC_PCFG_usMinFrTimeMsecMult10
	{0x002A, 0x030C},
	{0x0F12, 0x0000},   //REG_0TC_PCFG_uPrevMirror
	{0x0F12, 0x0000},   //REG_0TC_PCFG_uCaptureMirror

//	Preview config[1]
//	81MHz, 1920x1080, Dynamic 15 ~ 30fps
	{0x002A, 0x0312},	//REG_PrevConfigControls_1_
	{0x0F12,   1920},	//REG_1TC_PCFG_usWidth		1920
	{0x0F12,   1080},	//REG_1TC_PCFG_usHeight		1080
	{0x0F12, 0x0005},	//REG_1TC_PCFG_Format		YUV
	{0x002A, 0x031C},
	{0x0F12, 0x0100},	//REG_1TC_PCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_1TC_PCFG_uBpp88
	{0x0F12, 0x0050},   //REG_0TC_PCFG_PVIMask
	{0x0F12, 0x0000},	//REG_1TC_PCFG_OIFMask
	{0x0F12, 0x01E0},	//REG_1TC_PCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_1TC_PCFG_usJpegTotalPackets
	{0x0F12, 0x0001},	//REG_1TC_PCFG_uClockInd (1 : 81MHz)
	{0x0F12, 0x0002},	//0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0001},	//0: Dynamic, 1:BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, FRTIME_15},	//REG_1TC_PCFG_usMaxFrTimeMsecMult10
	{0x0F12, FRTIME_15},	//REG_1TC_PCFG_usMinFrTimeMsecMult10
	{0x002A, 0x033C},
	{0x0F12, 0x0000},	//REG_1TC_PCFG_uPrevMirror
	{0x0F12, 0x0000},	//REG_1TC_PCFG_uCaptureMirror

//	Preview config[2]
//	81MHz, 1280x720, Dynamic 15 ~ 30fps
	{0x002A, 0x0342},	//REG_PrevConfigControls_2_
	{0x0F12,   1280},	//REG_2TC_PCFG_usWidth		1280
	{0x0F12,    720},	//REG_2TC_PCFG_usHeight		720
	{0x0F12, 0x0005},	//REG_2TC_PCFG_Format		YUV
	{0x002A, 0x034C},
	{0x0F12, 0x0100},	//REG_2TC_PCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_2TC_PCFG_uBpp88
	{0x0F12, 0x0050},   //REG_0TC_PCFG_PVIMask
	{0x0F12, 0x0000},	//REG_2TC_PCFG_OIFMask
	{0x0F12, 0x01E0},	//REG_2TC_PCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_2TC_PCFG_usJpegTotalPackets
	{0x0F12, 0x0001},	//REG_2TC_PCFG_uClockInd (1 : 81MHz)
	{0x0F12, 0x0002},	//0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0001},	//0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, FRTIME_30},	//REG_2TC_PCFG_usMaxFrTimeMsecMult10
	{0x0F12, FRTIME_30},	//REG_2TC_PCFG_usMinFrTimeMsecMult10
	{0x002A, 0x036C},
	{0x0F12, 0x0000},	//REG_2TC_PCFG_uPrevMirror
	{0x0F12, 0x0000},	//REG_2TC_PCFG_uCaptureMirror

//	Preview config[3]
//	81MHz, 720x480, Dynamic 15 ~ 30fps
	{0x002A, 0x0372},
	{0x0F12,    720},	//REG_3TC_PCFG_usWidth		720
	{0x0F12,    480},	//REG_3TC_PCFG_usHeight		480
	{0x0F12, 0x0005},	//REG_3TC_PCFG_Format
	{0x002A, 0x037C},
	{0x0F12, 0x0100},	//REG_3TC_PCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_3TC_PCFG_uBpp88
	{0x0F12, 0x0050},   //REG_0TC_PCFG_PVIMask
	{0x0F12, 0x0000},	//REG_3TC_PCFG_OIFMask
	{0x0F12, 0x01E0},	//REG_3TC_PCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_3TC_PCFG_usJpegTotalPackets
	{0x0F12, 0x0001},	//REG_3TC_PCFG_uClockInd
	{0x0F12, 0x0002},	//REG_3TC_PCFG_usFrTimeType	0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0001},	//0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, FRTIME_30},	//REG_3TC_PCFG_usMaxFrTimeMsecMult10
	{0x0F12, FRTIME_30},	//REG_3TC_PCFG_usMinFrTimeMsecMult10
	{0x002A, 0x039C},
	{0x0F12, 0x0000},	//REG_3TC_PCFG_uPrevMirror
	{0x0F12, 0x0000},	//REG_3TC_PCFG_uCaptureMirror

//	Preview config[4]
//	81MHz, 640x480, Dynamic 15 ~ 30fps
	{0x002A, 0x03A2},
	{0x0F12,    640},	//REG_4TC_PCFG_usWidth		640
	{0x0F12,    480},	//REG_4TC_PCFG_usHeight		480
	{0x0F12, 0x0005},	//REG_4TC_PCFG_Format
	{0x002A, 0x03AC},
	{0x0F12, 0x0100},	//REG_4TC_PCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_4TC_PCFG_uBpp88
	{0x0F12, 0x0050},   //REG_4TC_PCFG_PVIMask
	{0x0F12, 0x0000},	//REG_4TC_PCFG_OIFMask
	{0x0F12, 0x01E0},	//REG_4TC_PCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_4TC_PCFG_usJpegTotalPackets
	{0x0F12, 0x0001},	//REG_4TC_PCFG_uClockInd
	{0x0F12, 0x0002},	//REG_4TC_PCFG_usFrTimeType	0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0001},	//0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, FRTIME_30},	//REG_4TC_PCFG_usMaxFrTimeMsecMult10
	{0x0F12, FRTIME_30},	//REG_4TC_PCFG_usMinFrTimeMsecMult10
	{0x002A, 0x03CC},
	{0x0F12, 0x0000},	//REG_4TC_PCFG_uPrevMirror
	{0x0F12, 0x0000},	//REG_4TC_PCFG_uCaptureMirror


//	Capture config[0] 2560X1920 (5MP)
	{0x002A, 0x03D2},  //REG_0TC_CCFG_uCaptureMode
    {0x0F12, 0x0000},  //AE AWB close
	{0x0F12,   2560},  //REG_0TC_CCFG_usWidth  2560
	{0x0F12,   1920},  //REG_0TC_CCFG_usHeight 1920
	{0x0F12, 0x0005},  //REG_0TC_CCFG_Format	 JPEG
	{0x002A, 0x03DE},
	{0x0F12, 0x0100},  //REG_0TC_CCFG_OutClkPerPix88
	{0x0F12, 0x0300},  //REG_0TC_CCFG_uBpp88
	{0x0F12, 0x0050},  //REG_0TC_PCFG_PVIMask
	{0x0F12, 0x0040},  //REG_0TC_CCFG_OIFMask												  //JPEG8
	{0x0F12, 0x0810},  //REG_0TC_CCFG_usJpegPacketSize
    {0x0F12, 0x0000},  //REG_0TC_CCFG_usJpegTotalPackets //SPOOF
    {0x0F12, 0x0001},  //REG_0TC_CCFG_uClockInd	(1 : 81MHz)
    {0x0F12, 0x0000},  //REG_0TC_CCFG_usFrTimeType			0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0002},  //REG_0TC_CCFG_FrRateQualityType		0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, CAP_MAXFRTIME},  //REG_0TC_CCFG_usMaxFrTimeMsecMult10
    {0x0F12, CAP_MINFRTIME},  //REG_0TC_CCFG_usMinFrTimeMsecMult10

//	Capture config[1] 2048X1536 (3MP)
	{0x002A, 0x03FE},	//REG_1TC_CCFG_uCaptureMode
    {0x0F12, 0x0000},	//AE AWB close
	{0x0F12,   2048},	//REG_1TC_CCFG_usWidth	2048
	{0x0F12,   1536},	//REG_1TC_CCFG_usHeight	1536
	{0x0F12, 0x0005},	//REG_1TC_CCFG_Format
	{0x002A, 0x040A},
	{0x0F12, 0x0100},	//REG_1TC_CCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_1TC_CCFG_uBpp88
	{0x0F12, 0x0050},   //REG_1TC_PCFG_PVIMask
	{0x0F12, 0x0040},	//REG_1TC_CCFG_OIFMask												   //JPEG8
	{0x0F12, 0x0810},	//REG_1TC_CCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_1TC_CCFG_usJpegTotalPackets //SPOOF
    {0x0F12, 0x0001},	//REG_1TC_CCFG_uClockInd
	{0x0F12, 0x0000},	//REG_1TC_CCFG_usFrTimeType			0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0002},	//REG_1TC_CCFG_FrRateQualityType	0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, CAP_MAXFRTIME},	//REG_1TC_CCFG_usMaxFrTimeMsecMult10
    {0x0F12, CAP_MINFRTIME},	//REG_1TC_CCFG_usMinFrTimeMsecMult10

//	Capture config[2] 1600X1200 (2MP)
	{0x002A, 0x042A},	//REG_2TC_CCFG_uCaptureMode
    {0x0F12, 0x0000},	//AE AWB close
	{0x0F12,   1600},	//REG_2TC_CCFG_usWidth	1600
	{0x0F12,   1200},	//REG_2TC_CCFG_usHeight	1200
	{0x0F12, 0x0005},	//REG_2TC_CCFG_Format
	{0x002A, 0x0436},
	{0x0F12, 0x0100},	//REG_2TC_CCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_2TC_CCFG_uBpp88
	{0x0F12, 0x0050},   //REG_2TC_PCFG_PVIMask
	{0x0F12, 0x0040},	//REG_2TC_CCFG_OIFMask												   //JPEG8
	{0x0F12, 0x0810},	//REG_2TC_CCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_2TC_CCFG_usJpegTotalPackets //SPOOF
    {0x0F12, 0x0001},	//REG_2TC_CCFG_uClockInd
	{0x0F12, 0x0000},	//REG_2TC_CCFG_usFrTimeType			0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0002},	//REG_2TC_CCFG_FrRateQualityType	0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, CAP_MAXFRTIME},	//REG_2TC_CCFG_usMaxFrTimeMsecMult10
    {0x0F12, CAP_MINFRTIME},	//REG_2TC_CCFG_usMinFrTimeMsecMult10

//	Capture config[3] 1024X768 (1MP)
	{0x002A, 0x0456},	//REG_3TC_CCFG_uCaptureMode
    {0x0F12, 0x0000},	//AE AWB close
	{0x0F12,   1024},	//REG_3TC_CCFG_usWidth	1024
	{0x0F12,    768},	//REG_3TC_CCFG_usHeight	768
	{0x0F12, 0x0005},	//REG_3TC_CCFG_Format
	{0x002A, 0x0462},
	{0x0F12, 0x0100},	//REG_3TC_CCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_3TC_CCFG_uBpp88
	{0x0F12, 0x0050},   //REG_3TC_PCFG_PVIMask
	{0x0F12, 0x0040},	//REG_3TC_CCFG_OIFMask												   //JPEG8
	{0x0F12, 0x0810},	//REG_3TC_CCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_3TC_CCFG_usJpegTotalPackets //SPOOF
    {0x0F12, 0x0001},	//REG_3TC_CCFG_uClockInd
	{0x0F12, 0x0000},	//REG_3TC_CCFG_usFrTimeType			0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0002},	//REG_3TC_CCFG_FrRateQualityType	0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, CAP_MAXFRTIME},	//REG_3TC_CCFG_usMaxFrTimeMsecMult10
    {0x0F12, CAP_MINFRTIME},	//REG_3TC_CCFG_usMinFrTimeMsecMult10

//	Capture config[4] 640x480 (VGA)
	{0x002A, 0x0482},	//REG_4TC_CCFG_uCaptureMode
    {0x0F12, 0x0000},	//AE AWB close
	{0x0F12,    640},	//REG_4TC_CCFG_usWidth	640
	{0x0F12,    480},	//REG_4TC_CCFG_usHeight	480
	{0x0F12, 0x0005},	//REG_4TC_CCFG_Format
	{0x002A, 0x048E},
	{0x0F12, 0x0100},	//REG_4TC_CCFG_OutClkPerPix88
	{0x0F12, 0x0300},	//REG_4TC_CCFG_uBpp88
	{0x0F12, 0x0050},   //REG_4TC_PCFG_PVIMask
	{0x0F12, 0x0040},	//REG_4TC_CCFG_OIFMask												   //JPEG8
	{0x0F12, 0x0810},	//REG_4TC_CCFG_usJpegPacketSize
	{0x0F12, 0x0000},	//REG_4TC_CCFG_usJpegTotalPackets //SPOOF
    {0x0F12, 0x0001},	//REG_4TC_CCFG_uClockInd
	{0x0F12, 0x0000},	//REG_4TC_CCFG_usFrTimeType			0: Dynamic, 1:Not Accurate, 2: Fixed
	{0x0F12, 0x0002},	//REG_4TC_CCFG_FrRateQualityType	0: Dynamic 1: BEST FrameRate(Binning), 2: BEST QUALITY(No Binning)
	{0x0F12, CAP_MAXFRTIME},	//REG_4TC_CCFG_usMaxFrTimeMsecMult10
    {0x0F12, CAP_MINFRTIME},	//REG_4TC_CCFG_usMinFrTimeMsecMult10

//WRITE #REG_TC_GP_bUse1FrameCaptureMode 1
//======================================================
// 19. Update Default Configuration
//======================================================
//	{0x002A, 0x02A0},
//	{0x0F12, 0x0000},  //REG_TC_GP_ActivePrevConfig
//	{0x002A, 0x02A8},
//	{0x0F12, 0x0000},  //REG_TC_GP_ActiveCapConfig
	{0x002A, 0x0266},
	{0x0F12, 0x0001},   //REG_TC_IPRM_InitParamsUpdated

//======================================================
// 20. Update Sen HW Default(After Sensor init) Directly
//======================================================
//WRITE D000F59E  0A6B  // aig_lp_dbs_ptr0
//WRITE D000F42E  00A6  // clp_sl_ctrl[7:6]=00
//WRITE D000F2AA  0020  // gain

//======================================================
// 21. Select Cofigration Display
//======================================================
//preview
//	{0x002A, 0x02A4},
//	{0x0F12, 0x0001},   //REG_TC_GP_PrevOpenAfterChange
//	{0x002A, 0x0288},
//	{0x0F12, 0x0001},   //REG_TC_GP_NewConfigSync

////WRITE  #REG_TC_AF
	{0x002A, 0x02CA},
	{0x0F12, 0x0000},
	{0x002A, 0x02C8},
	{0x0F12, 0x0003},   //REG_TC_AF_AfCmd
	{0x002A, 0x0278},
	{0x0F12, 0x0000},   //REG_TC_GP_EnablePreview
	{0x0F12, 0x0001},   //REG_TC_GP_EnablePreviewChanged
};

/* frame time low */
static const struct s5k5ea_reg_item s5k5ea_frame_time_low[] = {
	{0x0028, 0x2000},
	{0x002A, 0x02FE},
	{0x0F12, LOW_MAXFRTIME},	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
	{0x0F12, LOW_MINFRTIME},	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
};

/* frame time normal */
static const struct s5k5ea_reg_item s5k5ea_frame_time_normal[] = {
	{0x0028, 0x2000},
	{0x002A, 0x02FE},
	{0x0F12, NOR_MAXFRTIME},	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
	{0x0F12, NOR_MINFRTIME},	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
};

/* frame time high */
static const struct s5k5ea_reg_item s5k5ea_frame_time_high[] = {
	{0x0028, 0x2000},
	{0x002A, 0x02FE},
	{0x0F12, HIG_MAXFRTIME},	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
	{0x0F12, HIG_MINFRTIME},	/*REG_0TC_PCFG_usMaxFrTimeMsecMult10 */
};

/* Scene mode none */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_none[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x077F}, 	/* REG_TC_DBG_AutoAlgEnBits AWB_ON */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, 	/* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, 	/*REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000},	/* REG_TC_UserBrightness */
	{0x0F12, 0x0000},	/* REG_TC_UserContrast */
	{0x0F12, 0x0000},	/* REG_TC_UserSaturation */
	{0x0F12, 0x0000},	/* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0x0C3E},	/* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode portrait */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_portrait[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x077F}, 	/* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x050C},
	{0x0F12, 0x0002}, 	/* REG_SF_USER_IsoType */
	{0x0F12, 0x0100}, 	/* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000},	/* REG_TC_UserBrightness */
	{0x0F12, 0x0000},	/* REG_TC_UserContrast */
	{0x0F12, 0x0040},	/* REG_TC_UserSaturation */
	{0x0F12, 0xFF41},	/* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_2_	*/
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_3_	*/
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_4_	*/
	{0x0F12, 0x0201},	/* Mon_AE_WeightTbl_16_5_	*/
	{0x0F12, 0x0102},	/* Mon_AE_WeightTbl_16_6_	*/
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_7_	*/
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_8_	*/
	{0x0F12, 0x0202},	/* Mon_AE_WeightTbl_16_9_	*/
	{0x0F12, 0x0202},	/* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0201},	/* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0702},	/* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0207},	/* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0102},	/* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0201},	/* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0702},	/* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0207},	/* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0102},	/* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0201},	/* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0202},	/* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0202},	/* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0102},	/* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0202},	/* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0202},	/* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0X0C3E},	/* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode night */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_night[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x077F}, 	/* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, 	/* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, 	/* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0080},	/* REG_TC_UserBrightness */
	{0x0F12, 0x0000},	/* REG_TC_UserContrast */
	{0x0F12, 0x0000},	/* REG_TC_UserSaturation */
	{0x0F12, 0x0000},	/* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0x0C3E},	/* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode landscape */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_landscape[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x077F}, 	/* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, 	/* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, 	/* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000},	/* REG_TC_UserBrightness */
	{0x0F12, 0x0040},	/* REG_TC_UserContrast */
	{0x0F12, 0x0040},	/* REG_TC_UserSaturation */
	{0x0F12, 0x0080},	/* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0x0C3E},	/* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode sports */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_sports[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x0777}, /* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x04F6},
	{0x0F12, 0x05E0}, /* REG_SF_USER_Rgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_RgainChanged */
	{0x0F12, 0x0400}, /* REG_SF_USER_Ggain */
	{0x0F12, 0x0001}, /* REG_SF_USER_GgainChanged */
	{0x0F12, 0x0580}, /* REG_SF_USER_Bgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_BgainChanged */
	{0x002A, 0x050C},
	{0x0F12, 0x0003}, /* REG_SF_USER_IsoType */
	{0x0F12, 0x0400}, /* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000}, /* REG_TC_UserBrightness */
	{0x0F12, 0x0040}, /* REG_TC_UserContrast */
	{0x0F12, 0x0000}, /* REG_TC_UserSaturation */
	{0x0F12, 0x0040}, /* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0201}, /* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0102}, /* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0202}, /* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0202}, /* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0201}, /* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0702}, /* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0207}, /* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0102}, /* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0201}, /* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0702}, /* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0207}, /* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0102}, /* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0201}, /* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0202}, /* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0202}, /* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0102}, /* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0202}, /* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0202}, /* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0x0C3E}, /* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode indoor */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_indoor[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x077F}, 	/* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x050C},
	{0x0F12, 0x0002}, 	/* REG_SF_USER_IsoType */
	{0x0F12, 0x0100}, 	/* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000},	/* REG_TC_UserBrightness */
	{0x0F12, 0x0040},	/* REG_TC_UserContrast */
	{0x0F12, 0x0040},	/* REG_TC_UserSaturation */
	{0x0F12, 0x0040},	/* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0707},	/* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101},	/* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0x0C3E},	/* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode beach snow */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_beach_snow[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x0777}, /* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x04F6},
	{0x0F12, 0x0500}, /* REG_SF_USER_Rgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_RgainChanged */
	{0x0F12, 0x0400}, /* REG_SF_USER_Ggain */
	{0x0F12, 0x0001}, /* REG_SF_USER_GgainChanged */
	{0x0F12, 0x0580}, /* REG_SF_USER_Bgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_BgainChanged */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0040}, /* REG_TC_UserBrightness */
	{0x0F12, 0x0000}, /* REG_TC_UserContrast */
	{0x0F12, 0x0000}, /* REG_TC_UserSaturation */
	{0x0F12, 0x0000}, /* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_31_ */
	{0X002A, 0X0C3E}, /* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode sunset */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_sunset[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x0777}, /* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x04F6},
	{0x0F12, 0x05E0}, /* REG_SF_USER_Rgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_RgainChanged */
	{0x0F12, 0x0400}, /* REG_SF_USER_Ggain */
	{0x0F12, 0x0001}, /* REG_SF_USER_GgainChanged */
	{0x0F12, 0x0500}, /* REG_SF_USER_Bgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_BgainChanged */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000}, /* REG_TC_UserBrightness */
	{0x0F12, 0x0000}, /* REG_TC_UserContrast */
	{0x0F12, 0x0000}, /* REG_TC_UserSaturation */
	{0x0F12, 0x0000}, /* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_31_ */
	{0X002A, 0X0C3E}, /* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode firework */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_firework[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x0777}, /* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x04F6},
	{0x0F12, 0x05E0}, /* REG_SF_USER_Rgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_RgainChanged */
	{0x0F12, 0x0400}, /* REG_SF_USER_Ggain */
	{0x0F12, 0x0001}, /* REG_SF_USER_GgainChanged */
	{0x0F12, 0x0580}, /* REG_SF_USER_Bgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_BgainChanged */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000}, /* REG_TC_UserBrightness */
	{0x0F12, 0x0000}, /* REG_TC_UserContrast */
	{0x0F12, 0x0060}, /* REG_TC_UserSaturation */
	{0x0F12, 0x0060}, /* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_31_ */
	{0X002A, 0X0C3E}, /* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* Scene mode candle night */
static const struct s5k5ea_reg_item s5k5ea_scene_mode_candle_night[] = {
	{0x0028, 0x2000},
	{0x002A, 0x051C},
	{0x0F12, 0x0777}, /* REG_TC_DBG_AutoAlgEnBits AWB_OFF */
	{0x002A, 0x04F6},
	{0x0F12, 0x0600}, /* REG_SF_USER_Rgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_RgainChanged */
	{0x0F12, 0x0400}, /* REG_SF_USER_Ggain */
	{0x0F12, 0x0001}, /* REG_SF_USER_GgainChanged */
	{0x0F12, 0x0500}, /* REG_SF_USER_Bgain */
	{0x0F12, 0x0001}, /* REG_SF_USER_BgainChanged */
	{0x002A, 0x050C},
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoType */
	{0x0F12, 0x0000}, /* REG_SF_USER_IsoVal */
	{0x002A, 0x026A},
	{0x0F12, 0x0000}, /* REG_TC_UserBrightness */
	{0x0F12, 0x0000}, /* REG_TC_UserContrast */
	{0x0F12, 0x0000}, /* REG_TC_UserSaturation */
	{0x0F12, 0xFF41}, /* REG_TC_UserSharpBlur */
	{0x002A, 0x0B2E},
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_0_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_1_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_2_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_3_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_4_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_5_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_6_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_7_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_8_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_9_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_10_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_11_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_12_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_13_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_14_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_15_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_16_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_17_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_18_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_19_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_20_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_21_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_22_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_23_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_24_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_25_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_26_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_27_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_28_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_29_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_30_ */
	{0x0F12, 0x0101}, /* Mon_AE_WeightTbl_16_31_ */
	{0x002A, 0x0C3E}, /* ae_bWeightUpdtae */
	{0x0F12, 0x0001},
};

/* WB auto */
static const struct s5k5ea_reg_item s5k5ea_wb_auto[] = {
	{0x002A, 0x051C},
	{0x0F12, 0x077F},
};

/* WB Sunny */
static const struct s5k5ea_reg_item s5k5ea_wb_sunny[] = {
	{0x002A, 0x051C},
	{0x0F12, 0x0777},
	{0x002A, 0x04F6},
	{0x0F12, 0x04E1},
	{0x0F12, 0x0001},
	{0x0F12, 0x0400},
	{0x0F12, 0x0001},
	{0x0F12, 0x0652},
	{0x0F12, 0x0001},
};

/* WB Cloudy */
static const struct s5k5ea_reg_item s5k5ea_wb_cloudy[] = {
	{0x002A, 0x051C},
	{0x0F12, 0x0777},
	{0x002A, 0x04F6},
	{0x0F12, 0x0529},
	{0x0F12, 0x0001},
	{0x0F12, 0x0400},
	{0x0F12, 0x0001},
	{0x0F12, 0x04C2},
	{0x0F12, 0x0001},
};

/* WB Tungsten */
static const struct s5k5ea_reg_item s5k5ea_wb_tungsten[] = {
	{0x002A, 0x051C},
	{0x0F12, 0x0777},
	{0x002A, 0x04F6},
	{0x0F12, 0x0350},
	{0x0F12, 0x0001},
	{0x0F12, 0x0400},
	{0x0F12, 0x0001},
	{0x0F12, 0x0930},
	{0x0F12, 0x0001},
};

/* WB Fluorescent */
static const struct s5k5ea_reg_item s5k5ea_wb_fluorescent[] = {
	{0x002A, 0x051C},
	{0x0F12, 0x0777},
	{0x002A, 0x04F6},
	{0x0F12, 0x04F5},
	{0x0F12, 0x0001},
	{0x0F12, 0x0400},
	{0x0F12, 0x0001},
	{0x0F12, 0x06F5},
	{0x0F12, 0x0001},
};

/* Preview Input 2560x1920 */
static const struct s5k5ea_reg_item s5k5ea_preview_input_2560_1920[] = {
	{0x0028, 0x2000},
	{0x002A, 0x028A},
	{0x0F12, 0x0A00},	/* REG_TC_GP_PrevReqInputWidth */
	{0x0F12, 0x0780},	/* REG_TC_GP_PrevReqInputHeight */
	{0x0F12, 0x0000},
	{0x0F12, 0x0000},
	{0x002A, 0x029C},
	{0x0F12, 0x0001},	/* REG_TC_GP_bUseReqInputInPre */
	{0x002A, 0x04D0},
	{0x0F12, 0x0A00},	/* REG_TC_PZOOM_PrevZoomReqInputWidth */
	{0x0F12, 0x0780},	/* REG_TC_PZOOM_PrevZoomReqInputHeight */
	{0x0F12, 0x0000},	/* REG_TC_PZOOM_PrevZoomReqInputWidthOfs */
	{0x0F12, 0x0000},	/* REG_TC_PZOOM_PrevZoomReqInputHeightOfs */
};

/* Preview Input 1920x1080 */
static const struct s5k5ea_reg_item s5k5ea_preview_input_1920_1080[] = {
	{0x0028, 0x2000},
	{0x002A, 0x028A},
	{0x0F12, 0x0780},	/* REG_TC_GP_PrevReqInputWidth */
	{0x0F12, 0x0438},	/* REG_TC_GP_PrevReqInputHeight */
	{0x0F12, 0x0140},
	{0x0F12, 0x01A4},
	{0x002A, 0x029C},
	{0x0F12, 0x0001},	/* REG_TC_GP_bUseReqInputInPre */
	{0x002A, 0x04D0},
	{0x0F12, 0x0780},	/* REG_TC_PZOOM_PrevZoomReqInputWidth */
	{0x0F12, 0x0438},	/* REG_TC_PZOOM_PrevZoomReqInputHeight */
	{0x0F12, 0x0000},	/* REG_TC_PZOOM_PrevZoomReqInputWidthOfs */
	{0x0F12, 0x0000},	/* REG_TC_PZOOM_PrevZoomReqInputHeightOfs */
};

/* Preview Input 2560x1440 */
static const struct s5k5ea_reg_item s5k5ea_preview_input_2560_1440[] = {
	{0x0028, 0x2000},
	{0x002A, 0x028A},
	{0x0F12, 0x0A00},	/* REG_TC_GP_PrevReqInputWidth */
	{0x0F12, 0x05A0},	/* REG_TC_GP_PrevReqInputHeight */
	{0x0F12, 0x0000},
	{0x0F12, 0x00F0},
	{0x002A, 0x029C},
	{0x0F12, 0x0001},	/* REG_TC_GP_bUseReqInputInPre */
	{0x002A, 0x04D0},
	{0x0F12, 0x0A00},	/* REG_TC_PZOOM_PrevZoomReqInputWidth */
	{0x0F12, 0x05A0},	/* REG_TC_PZOOM_PrevZoomReqInputHeight */
	{0x0F12, 0x0000},	/* REG_TC_PZOOM_PrevZoomReqInputWidthOfs */
	{0x0F12, 0x0000},	/* REG_TC_PZOOM_PrevZoomReqInputHeightOfs */
};

#endif
