/*
 * Samsung Exynos5 SoC series Sensor driver
 *
 *
 * Copyright (c) 2011 Samsung Electronics Co., Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#include <linux/i2c.h>
#include <linux/slab.h>
#include <linux/irq.h>
#include <linux/interrupt.h>
#include <linux/delay.h>
#include <linux/version.h>
#include <linux/gpio.h>
#include <linux/clk.h>
#include <linux/regulator/consumer.h>
#include <linux/videodev2.h>
#include <linux/videodev2_exynos_camera.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/platform_device.h>
#ifdef CONFIG_OF
#include <linux/of_gpio.h>
#endif
#include <mach/regs-gpio.h>
#include <mach/regs-clock.h>
#include <plat/clock.h>
#include <plat/gpio-cfg.h>
#include <media/v4l2-ctrls.h>
#include <media/v4l2-device.h>
#include <media/v4l2-subdev.h>
#include <mach/exynos-fimc-is-sensor.h>

#include "../fimc-is-core.h"
#include "../fimc-is-device-sensor.h"
#include "../fimc-is-resourcemgr.h"
#include "../fimc-is-hw.h"
#include "fimc-is-device-mv9351.h"

#define SENSOR_NAME "MV9351"

static struct fimc_is_sensor_cfg config_mv9351[] = {
	/* 320x180@10fps : only for vision(settle) */
	FIMC_IS_SENSOR_CFG( 640,  480, 30, 12, 0),
	FIMC_IS_SENSOR_CFG(1280,  720, 60, 12, 1),
	FIMC_IS_SENSOR_CFG(1920, 1080, 30, 12, 2),
};

static struct fimc_is_vci vci_mv9351[] = {
	{
		.pixelformat = V4L2_PIX_FMT_YUYV,
		.vc_map = {2, 1, 0, 3}
	}, {
		.pixelformat = V4L2_PIX_FMT_JPEG,
		.vc_map = {0, 2, 1, 3}
	}
};

static int sensor_mv9351_open(struct v4l2_subdev *sd,
	struct v4l2_subdev_fh *fh)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);

	pr_info("%s\n", __func__);
	return 0;
}
static int sensor_mv9351_close(struct v4l2_subdev *sd,
	struct v4l2_subdev_fh *fh)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);
	return 0;
}
static int sensor_mv9351_registered(struct v4l2_subdev *sd)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);
	return 0;
}

static void sensor_mv9351_unregistered(struct v4l2_subdev *sd)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);
}

static const struct v4l2_subdev_internal_ops internal_ops = {
	.open = sensor_mv9351_open,
	.close = sensor_mv9351_close,
	.registered = sensor_mv9351_registered,
	.unregistered = sensor_mv9351_unregistered,
};

static int sensor_mv9351_init(struct v4l2_subdev *subdev, u32 val)
{
	int ret = 0;
	struct fimc_is_module_enum *module;
	struct fimc_is_module_mv9351 *module_mv9351;
	struct i2c_client *client;
	u8 wr_buf[] = {0x00, 0x01, 0x00, 0x00, 0xa0, 0x01};

	BUG_ON(!subdev);
	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	module_mv9351 = module->private_data;
	client = module->client;
	ret = fimc_is_sensor_write_buf(client, wr_buf, sizeof(wr_buf));

printk("CKKIM -> %s[%d] : {0x%02x,0x%02x,0x%02x,0x%02x}\n",__func__,__LINE__,
				wr_buf[0],wr_buf[1],wr_buf[2],wr_buf[3]);
	return 0;
}

static int sensor_mv9351_s_ctrl(struct v4l2_subdev *subdev, struct v4l2_control *ctrl)
{
	int ret = 0;

	switch (ctrl->id) {
//	case V4L2_CID_SCENEMODE:
//	case V4L2_CID_FOCUS_MODE:
//	case V4L2_CID_WHITE_BALANCE_PRESET:
//	case V4L2_CID_IMAGE_EFFECT:
//	case V4L2_CID_CAM_ISO:
//	case V4L2_CID_CAM_CONTRAST:
//	case V4L2_CID_CAM_SATURATION:
//	case V4L2_CID_CAM_SHARPNESS:
//	case V4L2_CID_CAM_BRIGHTNESS:
//	case V4L2_CID_CAM_METERING:
//	case V4L2_CID_CAM_SET_AUTO_FOCUS:
//	case V4L2_CID_CAM_OBJECT_POSITION_X:
//	case V4L2_CID_CAM_OBJECT_POSITION_Y:
//	case V4L2_CID_CAM_FACE_DETECTION:
//	case V4L2_CID_CAM_WDR:
//	case V4L2_CID_CAM_AUTO_FOCUS_RESULT:
//	case V4L2_CID_JPEG_QUALITY:
//	case V4L2_CID_CAM_AEAWB_LOCK_UNLOCK:
//	case V4L2_CID_CAM_CAF_START_STOP:
//	case V4L2_CID_CAM_ZOOM:
//		err("invalid ioctl(0x%08X) is requested", ctrl->id);
//		break;
//	case V4L2_CID_CAM_SINGLE_AUTO_FOCUS:
//		break;
//	case V4L2_CID_CAPTURE:
//		break;
//	case V4L2_CID_CAM_FLASH_MODE:
//		break;
//	case V4L2_CID_CAM_FRAME_RATE:
//		break;
	default:
		err("unsupported ioctl(0x%08X) is requested", ctrl->id);
		//ret = -EINVAL;
		ret = 0;
		break;
	}

	return ret;
}

static const struct v4l2_subdev_core_ops core_ops = {
	.init = sensor_mv9351_init,
	.s_ctrl	= sensor_mv9351_s_ctrl,
};

static int sensor_mv9351_s_stream(struct v4l2_subdev *subdev, int enable)
{
	int ret = 0;
	struct fimc_is_module_enum *sensor;

	pr_info("%s\n", __func__);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!sensor) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	if (enable) {
		ret = CALL_MOPS(sensor, stream_on, subdev);
		if (ret) {
			err("s_duration is fail(%d)", ret);
			goto p_err;
		}
	} else {
		ret = CALL_MOPS(sensor, stream_off, subdev);
		if (ret) {
			err("s_duration is fail(%d)", ret);
			goto p_err;
		}
	}

p_err:
	return 0;
}

static int sensor_mv9351_s_param(struct v4l2_subdev *subdev, struct v4l2_streamparm *param)
{
	int ret = 0;
	struct fimc_is_module_enum *sensor;
	struct v4l2_captureparm *cp;
	struct v4l2_fract *tpf;
	u64 duration;

	BUG_ON(!subdev);
	BUG_ON(!param);

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);

	cp = &param->parm.capture;
	tpf = &cp->timeperframe;

	if (!tpf->denominator) {
		err("denominator is 0");
		ret = -EINVAL;
		goto p_err;
	}

	if (!tpf->numerator) {
		err("numerator is 0");
		ret = -EINVAL;
		goto p_err;
	}

	duration = (u64)(tpf->numerator * 1000 * 1000 * 1000) /
					(u64)(tpf->denominator);

	sensor = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	if (!sensor) {
		err("sensor is NULL");
		ret = -EINVAL;
		goto p_err;
	}

	ret = CALL_MOPS(sensor, s_duration, subdev, duration);
	if (ret) {
		err("s_duration is fail(%d)", ret);
		goto p_err;
	}

p_err:
	return ret;
}

static int sensor_mv9351_s_format(struct v4l2_subdev *subdev, struct v4l2_mbus_framefmt *fmt)
{

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	/* TODO */
	return 0;
}

static const struct v4l2_subdev_video_ops video_ops = {
	.s_stream = sensor_mv9351_s_stream,
	.s_parm = sensor_mv9351_s_param,
	.s_mbus_fmt = sensor_mv9351_s_format
};

static const struct v4l2_subdev_ops subdev_ops = {
	.core = &core_ops,
	.video = &video_ops
};

int sensor_mv9351_stream_on(struct v4l2_subdev *subdev)
{
	struct fimc_is_module_enum *module;
	struct fimc_is_module_mv9351 *module_mv9351;
	struct i2c_client *client;
	int ret = 0;
	u8 run_cmd[] = {0xa0, 0x01};

	BUG_ON(!subdev);
	module = (struct fimc_is_module_enum *)v4l2_get_subdevdata(subdev);
	module_mv9351 = module->private_data;
	client = module->client;
printk("CKKIM -> %s[%d] : {0x%02x,0x%02x}\n",__func__,__LINE__,
				run_cmd[0],run_cmd[1]);

	ret = fimc_is_sensor_write_buf(client, run_cmd, sizeof(run_cmd));

	return ret;
}

int sensor_mv9351_stream_off(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
p_err:
	return 0;
}

/*
 * @ brief
 * frame duration time
 * @ unit
 * nano second
 * @ remarks
 */
int sensor_mv9351_s_duration(struct v4l2_subdev *subdev, u64 duration)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_mv9351_g_min_duration(struct v4l2_subdev *subdev)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_mv9351_g_max_duration(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_mv9351_s_exposure(struct v4l2_subdev *subdev, u64 exposure)
{
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return 0;
}

int sensor_mv9351_g_min_exposure(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_mv9351_g_max_exposure(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_mv9351_s_again(struct v4l2_subdev *subdev, u64 sensitivity)
{
	int ret = 0;

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	pr_info("%s\n", __func__);

	return ret;
}

int sensor_mv9351_g_min_again(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_mv9351_g_max_again(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_mv9351_s_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_mv9351_g_min_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

int sensor_mv9351_g_max_dgain(struct v4l2_subdev *subdev)
{
	int ret = 0;
printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	return ret;
}

struct fimc_is_sensor_ops module_mv9351_ops = {
	.stream_on	= sensor_mv9351_stream_on,
	.stream_off	= sensor_mv9351_stream_off,
	.s_duration	= sensor_mv9351_s_duration,
	.g_min_duration	= sensor_mv9351_g_min_duration,
	.g_max_duration	= sensor_mv9351_g_max_duration,
	.s_exposure	= sensor_mv9351_s_exposure,
	.g_min_exposure	= sensor_mv9351_g_min_exposure,
	.g_max_exposure	= sensor_mv9351_g_max_exposure,
	.s_again	= sensor_mv9351_s_again,
	.g_min_again	= sensor_mv9351_g_min_again,
	.g_max_again	= sensor_mv9351_g_max_again,
	.s_dgain	= sensor_mv9351_s_dgain,
	.g_min_dgain	= sensor_mv9351_g_min_dgain,
	.g_max_dgain	= sensor_mv9351_g_max_dgain
};

int sensor_mv9351_probe(struct i2c_client *client,
	const struct i2c_device_id *id)
{
	int ret = 0;
	struct fimc_is_core *core;
	struct v4l2_subdev *subdev_module;
	struct fimc_is_module_enum *module;
	struct fimc_is_device_sensor *device;
	struct sensor_open_extended *ext;
	static bool probe_retried = false;
	struct device *dev = &client->dev;

printk("CKKIM -> %s[%d] \n",__func__,__LINE__);
	if (!fimc_is_dev)
		goto probe_defer;

	core = (struct fimc_is_core *)dev_get_drvdata(fimc_is_dev);
	if (!core) {
		err("core device is not yet probed");
		return -EPROBE_DEFER;
	}

	device = &core->sensor[SENSOR_MV9351_INSTANCE];

	subdev_module = kzalloc(sizeof(struct v4l2_subdev), GFP_KERNEL);
	if (!subdev_module) {
		err("subdev_module is NULL");
		ret = -ENOMEM;
		goto p_err;
	}

	/* MV9351 */
	module = &device->module_enum[atomic_read(&core->resourcemgr.rsccount_module)];
	atomic_inc(&core->resourcemgr.rsccount_module);
	module->id = SENSOR_MV9351_NAME;
	module->subdev = subdev_module;
	module->device = SENSOR_MV9351_INSTANCE;
	module->ops = &module_mv9351_ops;
	module->client = client;
	module->active_width = 1920;
	module->active_height = 1080;
	module->pixel_width = module->active_width + 16;
	module->pixel_height = module->active_height + 10;
	module->max_framerate = 30;
	module->position = SENSOR_POSITION_FRONT;
	module->mode = CSI_MODE_VC_ONLY;
	module->lanes = CSI_DATA_LANES_2;
	module->vcis = ARRAY_SIZE(vci_mv9351);
	module->vci = vci_mv9351;
	module->setfile_name = "setfile_6b2.bin";
	module->cfgs = ARRAY_SIZE(config_mv9351);
	module->cfg = config_mv9351;
	module->private_data = kzalloc(sizeof(struct fimc_is_module_mv9351), GFP_KERNEL);
	if (!module->private_data) {
		err("private_data is NULL");
		ret = -ENOMEM;
		kfree(subdev_module);
		goto p_err;
	}

	ext = &module->ext;
	ext->mipi_lane_num = CSI_DATA_LANES_2;
	ext->I2CSclk = I2C_L0;
	ext->sensor_con.product_name = SENSOR_NAME_MV9351;
	ext->sensor_con.peri_type = SE_I2C;
	ext->sensor_con.peri_setting.i2c.channel = SENSOR_CONTROL_I2C2;
	ext->sensor_con.peri_setting.i2c.slave_address = 0x36;
	ext->sensor_con.peri_setting.i2c.speed = 400000;

	ext->from_con.product_name = FROMDRV_NAME_NOTHING;

	ext->companion_con.product_name = COMPANION_NAME_NOTHING;

	if (client) {
		v4l2_i2c_subdev_init(subdev_module, client, &subdev_ops);
		subdev_module->internal_ops = &internal_ops;
	} else {
		v4l2_subdev_init(subdev_module, &subdev_ops);
	}

	v4l2_set_subdevdata(subdev_module, module);
	v4l2_set_subdev_hostdata(subdev_module, device);
	snprintf(subdev_module->name, V4L2_SUBDEV_NAME_SIZE, "sensor-subdev.%d", module->id);

p_err:
	info("%s(%d)\n", __func__, ret);
	return ret;

probe_defer:
	if (probe_retried) {
		err("probe has already been retried!!");
		BUG();
	}

	probe_retried = true;
	err("core device is not yet probed");
	return -EPROBE_DEFER;
}

static int sensor_mv9351_remove(struct i2c_client *client)
{
	int ret = 0;
	return ret;
}

#ifdef CONFIG_OF
static const struct of_device_id exynos_fimc_is_sensor_mv9351_match[] = {
	{
		.compatible = "samsung,exynos5-fimc-is-sensor-mv9351",
	},
	{},
};
#endif

static const struct i2c_device_id sensor_mv9351_idt[] = {
	{ SENSOR_NAME, 0 },
};

static struct i2c_driver sensor_mv9351_driver = {
	.driver = {
		.name	= SENSOR_NAME,
		.owner	= THIS_MODULE,
#ifdef CONFIG_OF
		.of_match_table = exynos_fimc_is_sensor_mv9351_match
#endif
	},
	.probe	= sensor_mv9351_probe,
	.remove	= sensor_mv9351_remove,
	.id_table = sensor_mv9351_idt
};

static int __init sensor_mv9351_load(void)
{
        return i2c_add_driver(&sensor_mv9351_driver);
}

static void __exit sensor_mv9351_unload(void)
{
        i2c_del_driver(&sensor_mv9351_driver);
}

module_init(sensor_mv9351_load);
module_exit(sensor_mv9351_unload);

MODULE_AUTHOR("Gilyeon lim");
MODULE_DESCRIPTION("Sensor 8B1 driver");
MODULE_LICENSE("GPL v2");
