#include "oduino.h"
#include "ui_oduino.h"
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

#define DEVICE  "/dev/ttyACM0"

Oduino::Oduino(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::Oduino)
{
    ui->setupUi(this);
    fd = -1;

    mRedBrush = new QBrush(QColor(Qt::red));
    ui->Thermo_Celsius->setFillBrush(*mRedBrush);
    ui->Thermo_Fahrenheit->setFillBrush(*mRedBrush);
    mBlueBrush = new QBrush(QColor(Qt::blue));
    ui->Thermo_Hygrometer->setFillBrush(*mBlueBrush);

    fd = open(DEVICE, O_RDWR | O_NOCTTY | O_NONBLOCK);
    memset(&newtio, 0, sizeof(newtio));

    if (fd < 0)
        printf("/dev/ttyACM0 open fail!\n");

    newtio.c_cflag = B115200 | CS8 | CLOCAL | CREAD;
    newtio.c_iflag = IGNPAR;
    newtio.c_oflag = 0;
    newtio.c_lflag = 0;

    tcflush(fd, TCIFLUSH);
    tcsetattr(fd, TCSANOW, &newtio);

    notRsRead = new QSocketNotifier(fd, QSocketNotifier::Read, this);
    connect(notRsRead, SIGNAL(activated(int)), this, SLOT(setEvent()));
}

Oduino::~Oduino()
{
    delete mRedBrush;
    delete mBlueBrush;
    delete notRsRead;
    ::close(fd);
}

void Oduino::setEvent()
{
    int szRead;
    memset(buf, 0x00, BUFF_SIZE);
    szRead = read(fd, buf, BUFF_SIZE);

    if (buf[0] == 'O' && buf[1] == 'K') {
        if (szRead == 12) {
            memcpy(buf2, &buf[3], szRead - 3);

            int i = 0;
            for (; i < szRead - 3; i++) {
                if (buf2[i] >= '0' && buf2[i] <= '9') {
                    int humidity = 0;
                    humidity = (buf2[i] - '0') * 10;
                    humidity += buf2[i + 1] - '0';
                    ui->Thermo_Hygrometer->setValue(humidity);
                    ui->lcdNumber_Humidity->display(humidity);
                    //printf("humidity %d\n", humidity);
                    i += 2;
                    break;
                }
            }
            
            for (; i < szRead - 4; i++) {
                if (buf2[i] >= '0' && buf2[i] <= '9') {
                    int celsius = 0;
                    celsius = (buf2[i] - '0') * 10;
                    celsius += buf2[i + 1] - '0';
                    //printf("celsius %d\n", celsius);
                    ui->Thermo_Celsius->setValue(celsius);
                    ui->lcdNumber_Celsius->display(celsius);
                    int fahrenheit = celsius * 1.8 + 32;
                    ui->Thermo_Fahrenheit->setValue(fahrenheit);
                    ui->lcdNumber_Fahrenheit->display(fahrenheit);
                    //printf("fahrenheit %d\n", fahrenheit);
                    break;
                }
            }
        }
    }
}
