/* linux/arch/arm/mach-exynos/include/mach/asv-exynos5422.h
*
* Copyright (c) 2013 Samsung Electronics Co., Ltd.
*              http://www.samsung.com/
*
* EXYNOS5422 - Adoptive Support Voltage Header file
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_EXYNOS5422_ASV_H
#define __ASM_ARCH_EXYNOS5422_ASV_H __FILE__

#define ARM_DVFS_LEVEL_NR		(20)
#define ARM_ASV_GRP_NR			(14)
#define ARM_MAX_VOLT			(1362500)
#define ARM_V300_BIN2_DVFS_LEVEL_NR	(17)
#define ARM_V300_BIN2_MAX_VOLT		(1237500)

#define INT_DVFS_LEVEL_NR		(11)
#define INT_ASV_GRP_NR			(14)
#define INT_MAX_VOLT			(987500)
#define INT_V240_MAX_VOLT		(975000)
#define INT_V230_MAX_VOLT		(987500)
#define INT_V300_BIN2_MAX_VOLT		(1025000)

#define MIF_DVFS_LEVEL_NR		(10)
#define MIF_ASV_GRP_NR			(14)
#define MIF_MAX_VOLT			(975000)
#define MIF_V240_MAX_VOLT		(962500)
#define MIF_V230_MAX_VOLT		(962500)
#define MIF_V300_BIN2_MAX_VOLT		(1000000)

#define G3D_DVFS_LEVEL_NR		(7)
#define G3D_ASV_GRP_NR			(14)
#define G3D_MAX_VOLT			(975000)
#define G3D_V240_MAX_VOLT		(1000000)
#define G3D_V230_MAX_VOLT		(1000000)
#define G3D_V300_BIN2_MAX_VOLT		(1050000)

#define KFC_DVFS_LEVEL_NR		(14)
#define KFC_ASV_GRP_NR			(14)
#define KFC_MAX_VOLT			(1300000)
#define KFC_V300_BIN2_DVFS_LEVEL_NR	(12)
#define KFC_V300_BIN2_MAX_VOLT		(1250000)

#define ISP_DVFS_LEVEL_NR		(7)
#define ISP_ASV_GRP_NR			(14)
#define ISP_MAX_VOLT			(1012500)
#define ISP_V240_MAX_VOLT		(962500)
#define ISP_V230_MAX_VOLT		(1012500)
#define ISP_V300_BIN2_MAX_VOLT		(1050000)

static unsigned int refer_table_get_asv[2][ARM_ASV_GRP_NR] = {
	{ 13, 21, 25, 30, 36, 43, 51, 65, 81, 98, 119, 135, 150, 999},
	{ 55, 65, 69, 72, 74, 76, 78, 80, 82, 84, 87, 89, 92, 999},
};

static unsigned int refer_use_table_get_asv[2][ARM_ASV_GRP_NR] = {
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
};

static unsigned int arm_asv_abb_info[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 2000000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1900000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        { 1000000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  900000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
};

static unsigned int arm_asv_abb_info_v300_BIN2[ARM_V300_BIN2_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 1800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{ 1000000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  900000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
	{  200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,    ABB_X130},
};

static unsigned int int_asv_abb_info[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
        {  600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  480000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  460000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  440000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  420000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  333000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  222000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  111000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {   83000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
};

static unsigned int int_asv_abb_info_v300_BIN2[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
        {  600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  480000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  460000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  440000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  420000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  333000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  222000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  111000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {   83000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
};

static unsigned int mif_asv_abb_info[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
        {  825000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  728000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  633000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  543000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  413000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  275000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  206000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  165000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
        {  138000,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130,   ABB_X130},
};

static unsigned int g3d_asv_abb_info[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  543000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120},
	{  480000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120},
	{  420000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120},
	{  350000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120,   ABB_X120},
	{  266000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  177000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
};

static unsigned int g3d_asv_abb_info_v230_v240[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  543000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  480000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  420000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  350000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  266000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  177000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
};

static unsigned int kfc_asv_abb_info[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
        { 1500000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        { 1400000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        { 1300000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        { 1200000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        { 1100000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        { 1000000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  900000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
        {  200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
};

static unsigned int kfc_asv_abb_info_v300_BIN2[KFC_V300_BIN2_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 1300000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{ 1200000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{ 1100000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{ 1000000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  900000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  800000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  700000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  600000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  500000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  400000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  300000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
	{  200000,   ABB_X070,   ABB_X070,   ABB_X070,   ABB_X080,   ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS},
};

static unsigned int arm_asv_volt_info_evt1[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2100000, 1362500, 1362500, 1350000, 1337500, 1325000, 1312500, 1300000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000},
	{ 2000000, 1312500, 1312500, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1900000, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1162500, 1150000, 1137500, 1125000, 1112500},
	{ 1800000, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1112500, 1100000, 1087500, 1075000, 1062500},
	{ 1700000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1075000, 1062500, 1050000, 1037500, 1025000},
	{ 1600000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1037500, 1025000, 1012500, 1000000,  987500},
	{ 1500000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500, 1000000,  987500,  975000,  962500,  950000},
	{ 1400000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  975000,  962500,  950000,  937500,  925000},
	{ 1300000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  962500,  950000,  937500,  925000,  912500},
	{ 1200000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  937500,  925000,  912500,  900000,  900000},
	{ 1100000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000},
	{ 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  900000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  800000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  700000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int arm_asv_volt_info_evt1_v240[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2100000, 1362500, 1362500, 1350000, 1337500, 1325000, 1312500, 1300000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000},
	{ 2000000, 1312500, 1312500, 1312500, 1300000, 1275000, 1262500, 1250000, 1237500, 1225000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1900000, 1262500, 1250000, 1250000, 1237500, 1212500, 1200000, 1187500, 1175000, 1162500, 1175000, 1162500, 1150000, 1137500, 1125000},
	{ 1800000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1125000, 1112500, 1100000, 1087500, 1075000},
	{ 1700000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1087500, 1075000, 1062500, 1050000, 1037500},
	{ 1600000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1050000, 1037500, 1025000, 1012500, 1000000},
	{ 1500000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000, 1012500, 1000000,  987500,  975000,  962500},
	{ 1400000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  987500,  975000,  962500,  950000,  937500},
	{ 1300000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  962500,  950000,  937500,  925000,  912500},
	{ 1200000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  937500,  925000,  912500,  900000,  900000},
	{ 1100000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000},
	{ 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  900000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  800000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  700000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int arm_asv_volt_info_evt1_v230[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2100000, 1362500, 1362500, 1350000, 1337500, 1325000, 1312500, 1300000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000},
	{ 2000000, 1312500, 1312500, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1900000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1175000, 1162500, 1150000, 1137500, 1125000},
	{ 1800000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1125000, 1112500, 1100000, 1087500, 1075000},
	{ 1700000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1087500, 1075000, 1062500, 1050000, 1037500},
	{ 1600000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1050000, 1037500, 1025000, 1012500, 1000000},
	{ 1500000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000, 1012500, 1000000,  987500,  975000,  962500},
	{ 1400000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  987500,  975000,  962500,  950000,  937500},
	{ 1300000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  962500,  950000,  937500,  925000,  912500},
	{ 1200000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  937500,  925000,  912500,  900000,  900000},
	{ 1100000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000},
	{ 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  900000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  800000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  700000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int arm_asv_volt_info_evt1_v300_BIN2[ARM_V300_BIN2_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 1800000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1150000, 1137500, 1125000, 1112500, 1100000},
	{ 1700000, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1112500, 1100000, 1087500, 1075000, 1062500},
	{ 1600000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1075000, 1062500, 1050000, 1037500, 1025000},
	{ 1500000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1037500, 1025000, 1012500, 1000000,  987500},
	{ 1400000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000, 1012500, 1000000,  987500, 	975000,  962500},
	{ 1300000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500, 1000000,  987500,  975000, 	962500,  950000},
	{ 1200000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  975000,  962500,  950000, 	937500,  925000},
	{ 1100000, 1037500, 1025000, 1012500, 1000000, 	987500,  975000,  962500,  950000,  937500,  950000,  937500,  925000, 	912500,  900000},
	{ 1000000, 1012500, 1000000,  987500,  975000, 	962500,  950000,  937500,  925000,  912500,  925000,  912500,  900000,  900000,  900000},
	{  900000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
	{  800000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  700000,  937500,  925000,  912500,  900000, 	900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
	{  600000,  900000,  900000,  900000,  900000, 	900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
	{  500000,  900000,  900000,  900000,  900000, 	900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
	{  400000,  900000,  900000,  900000,  900000, 	900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
	{  300000,  900000,  900000,  900000,  900000, 	900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
	{  200000,  900000,  900000,  900000,  900000, 	900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000, 	900000,  900000},
};

static unsigned int kfc_asv_volt_info_evt1[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 1500000, 1300000, 1300000, 1300000, 1287500, 1287500, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1400000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500},
	{ 1300000, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500},
	{ 1200000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500},
	{ 1100000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000},
	{ 1000000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500},
	{  900000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000},
	{  800000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000},
	{  700000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int kfc_asv_volt_info_evt1_v240[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 1500000, 1300000, 1300000, 1300000, 1287500, 1287500, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1400000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500},
	{ 1300000, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500},
	{ 1200000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500},
	{ 1100000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000},
	{ 1000000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500},
	{  900000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000},
	{  800000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000},
	{  700000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int kfc_asv_volt_info_evt1_v230[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 1500000, 1300000, 1300000, 1300000, 1287500, 1287500, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1400000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500},
	{ 1300000, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500},
	{ 1200000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500},
	{ 1100000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000},
	{ 1000000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500},
	{  900000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000},
	{  800000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000},
	{  700000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int kfc_asv_volt_info_evt1_v300_BIN2[KFC_V300_BIN2_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 1300000, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500},
	{ 1200000, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500},
	{ 1100000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000},
	{ 1000000, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500},
	{  900000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,	937500,  925000},
	{  800000, 1050000, 1037500, 1025000, 1012500, 1000000,  98750 ,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000},
	{  700000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000},
	{  600000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},

};

static unsigned int int_asv_volt_info_evt1[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{  600000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  900000,  887500,  875000,  862500,  850000},
	{  500000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  480000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  460000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  440000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  420000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  400000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  333000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  222000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  111000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{   83000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int int_asv_volt_info_evt1_v240[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{  600000,  962500,  950000,  925000,  912500,  900000,  887500,  875000,  875000,  875000,  887500,  875000,  862500,  850000,  850000},
	{  500000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  875000,  875000,  887500,  875000,  862500,  850000,  850000},
	{  480000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  875000,  875000,  887500,  875000,  862500,  850000,  850000},
	{  460000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  875000,  875000,  887500,  875000,  862500,  850000,  850000},
	{  440000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  875000,  875000,  887500,  875000,  862500,  850000,  850000},
	{  420000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  400000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  875000,  875000,  862500,  875000,  862500,  850000,  850000},
	{  333000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  222000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  111000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{   83000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int int_asv_volt_info_evt1_v230[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{  600000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  900000,  887500,  875000,  862500,  850000},
	{  500000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  480000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  460000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  440000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  420000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  887500,  875000,  862500,  850000,  850000},
	{  400000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  333000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  222000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  111000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{   83000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int int_asv_volt_info_evt1_v300_BIN2[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{ 600000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  937500,  925000,  912500,  900000,  887500},
	{ 500000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  925000,  912500,  900000,  887500,  887500},
	{ 480000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  925000,  912500,  900000,  887500,  887500},
	{ 460000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  925000,  912500,  900000,  887500,  887500},
	{ 440000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  925000,  912500,  900000,  887500,  887500},
	{ 420000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  925000,  912500,  900000,  887500,  887500},
	{ 400000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
	{ 333000,  950000,  937500,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
	{ 222000,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
	{ 111000,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
	{  83000,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500,  887500},
};

static unsigned int mif_asv_volt_info_evt1[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{  825000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500},
	{  728000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  633000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500},
	{  543000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500},
	{  413000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  275000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  206000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  165000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  138000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{   69000,  775000,  763000,  750000,  738000,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
};

static unsigned int mif_asv_volt_info_evt1_v240[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{  825000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500},
	{  728000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  633000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500},
	{  543000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500},
	{  413000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  275000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  206000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  165000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  138000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{   69000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
};

static unsigned int mif_asv_volt_info_evt1_v230[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{  825000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500},
	{  728000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500},
	{  633000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500},
	{  543000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500},
	{  413000,  812500,  800000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  275000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  206000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  165000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
	{  138000,  787500,  775000,  762500,  750000,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500,  737500},
};

static unsigned int mif_asv_volt_info_evt1_v300_BIN2[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{ 825000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500},
	{ 728000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000},
	{ 633000,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  775000},
	{ 543000,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  775000,  775000,  775000},
	{ 413000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500},
	{ 275000,  812500,  800000,  787500,  775000,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500},
	{ 206000,  812500,  800000,  787500,  775000,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500},
	{ 165000,  812500,  800000,  787500,  775000,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500},
	{ 138000,  812500,  800000,  787500,  775000,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500,  762500},
};

static unsigned int g3d_asv_volt_info_evt1[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  543000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500},
	{  480000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500},
	{  420000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000},
	{  350000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000},
	{  260000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000,  750000,  750000},
	{  177000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
	{  100000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
};

static unsigned int g3d_asv_volt_info_evt1_v240[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  543000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500},
	{  480000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500},
	{  420000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000},
	{  350000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000},
	{  266000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000,  750000,  750000},
	{  177000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
	{  100000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
};

static unsigned int g3d_asv_volt_info_evt1_v230[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{  543000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500},
	{  480000,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500},
	{  420000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000},
	{  350000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000},
	{  266000,  862500,  850000,  837500,  825000,  812500,  800000,  787500,  775000,  762500,  750000,  750000,  750000,  750000,  750000},
	{  177000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
	{  100000,  800000,  787500,  775000,  762500,  750000,  737500,  725000,  725000,  725000,  725000,  725000,  725000,  725000,  725000},
};

static unsigned int g3d_asv_volt_info_evt1_v300_BIN2[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{ 543000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500},
	{ 480000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500},
	{ 420000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000},
	{ 350000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000},
	{ 266000,  912500,  900000,  887500,  875000,  862500,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000},
	{ 177000,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000},
	{ 100000,  850000,  837500,  825000,  812500,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000,  800000},
};

static unsigned int isp_asv_volt_info_evt1[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{  666000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  555000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  444000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  333000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
	{  222000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
	{  111000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
	{  100000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int isp_asv_volt_info_evt1_v240[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{  666000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  887500,  887500,  875000,  875000,  862500,  862500,  862500},
	{  555000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  887500,  887500,  875000,  875000,  862500,  862500,  862500},
	{  444000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  887500,  887500,  875000,  875000,  862500,  862500,  862500},
	{  333000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  222000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  111000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
	{  100000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int isp_asv_volt_info_evt1_v230[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{  666000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  555000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  444000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000},
	{  333000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
	{  222000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
	{  111000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
	{  100000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  875000,  862500,  850000,  850000,  850000,  850000,  850000},
};

static unsigned int isp_asv_volt_info_evt1_v300_BIN2[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{  666000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500},
	{  555000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500},
	{  444000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500},
	{  333000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500},
	{  222000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500},
	{  111000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500},
	{  100000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  887500,  887500,  887500,  887500,  887500},
};

static unsigned int mif_sram_asv_volt_info_evt1[1][MIF_ASV_GRP_NR] = {
	{ 975000, 975000, 950000, 950000, 925000, 925000, 900000, 900000, 900000, 900000, 900000, 900000, 900000, 900000},
};
static unsigned int mif_sram_asv_volt_info_evt1_v300_BIN2[1][MIF_ASV_GRP_NR] = {
	{ 1000000, 1000000,  975000,  975000,  950000,  950000,  925000,  925000,  900000,  900000,  900000,  900000,  900000,	900000},
};

static unsigned int g3d_sram_asv_volt_info_evt1[1][G3D_ASV_GRP_NR] = {
	{ 1000000, 1000000, 975000, 975000, 950000, 950000, 925000, 925000, 900000, 900000, 900000, 900000, 900000, 900000},
};
static unsigned int g3d_sram_asv_volt_info_evt1_v300_BIN2[1][G3D_ASV_GRP_NR] = {
	{ 1050000, 1050000, 1025000, 1025000, 1000000, 1000000,  975000,  975000,  950000,  950000,  925000,  925000,  900000,	900000},
};

#endif /* EXYNOS5422_ASV_H */
