/* linux/arch/arm/mach-exynos/include/mach/asv-exynos5422.h
*
* Copyright (c) 2013 Samsung Electronics Co., Ltd.
*              http://www.samsung.com/
*
* EXYNOS5422 - Adoptive Support Voltage Header file
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*/

#ifndef __ASM_ARCH_EXYNOS5422_ASV_H
#define __ASM_ARCH_EXYNOS5422_ASV_H __FILE__

#define ARM_DVFS_LEVEL_NR		(20)
#define ARM_ASV_GRP_NR			(14)
#define ARM_MAX_VOLT			(1312500)

#define INT_DVFS_LEVEL_NR		(11)
#define INT_ASV_GRP_NR			(14)
#define INT_MAX_VOLT			(925000)

#define MIF_DVFS_LEVEL_NR		(9)
#define MIF_ASV_GRP_NR			(14)
#define MIF_MAX_VOLT			(962500)

#define G3D_DVFS_LEVEL_NR		(7)
#define G3D_ASV_GRP_NR			(14)
#define G3D_MAX_VOLT			(987500)

#define KFC_DVFS_LEVEL_NR		(14)
#define KFC_ASV_GRP_NR			(14)
#define KFC_MAX_VOLT			(1300000)

#define ISP_DVFS_LEVEL_NR		(7)
#define ISP_ASV_GRP_NR			(14)
#define ISP_MAX_VOLT			(1300000)

static unsigned int refer_table_get_asv[2][ARM_ASV_GRP_NR] = {
	{ 13, 21, 25, 30, 36, 43, 51, 65, 81, 98, 119, 135, 150, 999},
	{ 55, 65, 69, 72, 74, 76, 78, 80, 82, 84, 87, 89, 92, 999},
};

static unsigned int refer_use_table_get_asv[2][ARM_ASV_GRP_NR] = {
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
};

static unsigned int arm_asv_abb_info[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
        { 2100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 2000000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1900000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 1000000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 900000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
        { 200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130},
};

static unsigned int int_asv_abb_info[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
        { 600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 480000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 460000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 440000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 420000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 333000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 222000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 111000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 83000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
};

static unsigned int mif_asv_abb_info[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
        { 825000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 728000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 633000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 543000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 413000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 275000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 206000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 165000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
        { 138000, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130, ABB_X130 },
};

static unsigned int g3d_asv_abb_info[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
        { 543000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 480000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 420000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 350000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 266000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 177000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 100000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
};

static unsigned int kfc_asv_abb_info[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
        { 1500000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 1400000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 1300000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 1200000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 1100000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 1000000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 900000, ABB_X070, ABB_X070, ABB_X070, ABB_X080, ABB_X080, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 800000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 700000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 600000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 500000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 400000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 300000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
        { 200000, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS, ABB_BYPASS },
};

static unsigned int arm_asv_volt_info_evt1[ARM_DVFS_LEVEL_NR][ARM_ASV_GRP_NR + 1] = {
	{ 2100000, 1362500, 1362500, 1350000, 1337500, 1325000, 1312500, 1300000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000},
	{ 2000000, 1312500, 1312500, 1300000, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1900000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1175000, 1162500, 1150000, 1137500, 1125000},
	{ 1800000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1125000, 1112500, 1100000, 1087500, 1075000},
	{ 1700000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1087500, 1075000, 1062500, 1050000, 1037500},
	{ 1600000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1050000, 1037500, 1025000, 1012500, 1000000},
	{ 1500000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000, 1012500, 1000000,  987500,  975000,  962500},
	{ 1400000, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  987500,  975000,  962500,  950000,  937500},
	{ 1300000, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  962500,  950000,  937500,  925000,  912500},
	{ 1200000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  937500,  925000,  912500,  900000,  900000},
	{ 1100000, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000},
	{ 1000000,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  900000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  800000,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  700000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int kfc_asv_volt_info_evt1[KFC_DVFS_LEVEL_NR][KFC_ASV_GRP_NR + 1] = {
	{ 1500000, 1300000, 1300000, 1300000, 1287500, 1287500, 1287500, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500},
	{ 1400000, 1275000, 1262500, 1250000, 1237500, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500},
	{ 1300000, 1225000, 1212500, 1200000, 1187500, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500},
	{ 1200000, 1175000, 1162500, 1150000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500},
	{ 1100000, 1137500, 1125000, 1112500, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000},
	{ 1000000, 1100000, 1087500, 1075000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500},
	{  900000, 1062500, 1050000, 1037500, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000},
	{  800000, 1025000, 1012500, 1000000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000},
	{  700000,  987500,  975000,  962500,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  600000,  950000,  937500,  925000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  500000,  912500,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  400000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  300000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
	{  200000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000,  900000},
};

static unsigned int int_asv_volt_info_evt1[INT_DVFS_LEVEL_NR][INT_ASV_GRP_NR + 1] = {
	{ 600000, 987500, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 900000, 887500, 875000, 862500, 850000},
	{ 500000, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 887500, 875000, 862500, 850000, 850000},
	{ 480000, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 887500, 875000, 862500, 850000, 850000},
	{ 460000, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 887500, 875000, 862500, 850000, 850000},
	{ 440000, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 887500, 875000, 862500, 850000, 850000},
	{ 420000, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 887500, 875000, 862500, 850000, 850000},
	{ 400000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000, 850000, 850000},
	{ 333000, 912500, 900000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000},
	{ 222000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000},
	{ 111000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000},
	{  83000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000, 850000},
};

static unsigned int mif_asv_volt_info_evt1[MIF_DVFS_LEVEL_NR][MIF_ASV_GRP_NR + 1] = {
	{ 825000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 837500, 825000, 812500, 800000},
	{ 728000, 912500, 900000, 887500, 875000, 862500, 850000, 837500, 825000, 812500, 800000, 787500, 775000, 762500, 750000},
	{ 633000, 875000, 862500, 850000, 837500, 825000, 812500, 800000, 787500, 775000, 762500, 750000, 737500, 725000, 725000},
	{ 543000, 850000, 837500, 825000, 812500, 800000, 787500, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000},
	{ 413000, 800000, 787500, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
	{ 275000, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
	{ 206000, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
	{ 165000, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
	{ 138000, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
};

static unsigned int g3d_asv_volt_info_evt1[G3D_DVFS_LEVEL_NR][G3D_ASV_GRP_NR + 1] = {
	{ 543000, 1000000, 987500, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 837500},
	{ 480000,  950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 837500, 825000, 812500, 800000, 787500},
	{ 420000,  912500, 900000, 887500, 875000, 862500, 850000, 837500, 825000, 812500, 800000, 787500, 775000, 762500, 750000},
	{ 350000,  887500, 875000, 862500, 850000, 837500, 825000, 812500, 800000, 787500, 775000, 762500, 750000, 750000, 750000},
	{ 266000,  862500, 850000, 837500, 825000, 812500, 800000, 787500, 775000, 762500, 750000, 750000, 750000, 750000, 750000},
	{ 177000,  800000, 787500, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
	{ 100000,  800000, 787500, 775000, 762500, 750000, 737500, 725000, 725000, 725000, 725000, 725000, 725000, 725000, 725000},
};

static unsigned int isp_asv_volt_info_evt1[ISP_DVFS_LEVEL_NR][ISP_ASV_GRP_NR + 1] = {
	{ 666000, 1012500, 1000000, 987500, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000},
	{ 555000, 1012500, 1000000, 987500, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000},
	{ 444000, 1012500, 1000000, 987500, 975000, 962500, 950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000},
	{ 333000,  962500,  950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000},
	{ 222000,  962500,  950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000},
	{ 111000,  962500,  950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000},
	{ 100000,  962500,  950000, 937500, 925000, 912500, 900000, 887500, 875000, 862500, 850000, 850000, 850000, 850000, 850000},
};

static unsigned int mif_sram_asv_volt_info_evt1[1][MIF_ASV_GRP_NR] = {
	{ 975000, 950000, 950000, 925000, 925000, 900000, 900000, 900000, 900000, 900000, 900000, 900000, 900000, 900000},
};

static unsigned int g3d_sram_asv_volt_info_evt1[1][G3D_ASV_GRP_NR] = {
	{ 1000000, 1000000, 975000, 975000, 950000, 950000, 925000, 925000, 900000, 900000, 900000, 900000, 900000, 900000},
};

#endif /* EXYNOS5422_ASV_H */
