#!/bin/sh
#
# Hakjoo kim <ruppi.kim@hardkernel.com> Hardkernel Co.,Ltd.
#

whereiam=$(cd $(dirname $0) && pwd)

fstab=${whereiam}/fstab
flash_kernel=${whereiam}/flash-kernel
MODEL=`echo $(grep "Hardware" /proc/cpuinfo) | cut -d ' ' -f3`
model=`echo $MODEL | tr A-Z a-z`
deb_name=`echo $(ls -l linux-image-*.deb) | cut -d ' ' -f9`
deb_addver=`echo ${deb_name} | cut -d '-' -f3`
deb_appendver=`echo ${deb_name} | cut -d '-' -f4 | cut -d '_' -f1` 
install_linux_image()
{
	if [ -f /var/lib/initramfs-tools/3.7.0-rc5 ]; then
		echo "remove dirty files"
		rm -fv /var/lib/initramfs-tools/*
	fi
	if [ -f $fstab ]; then
		cp -v $fstab /etc/fstab
	fi
	if [ -f $flash_kernel ]; then
		cp -v $flash_kernel /usr/sbin/flash-kernel
	fi

	echo "Installing linux image and linux headers debian package"
	dpkg -i *${model}*.deb
	
	flash-kernel $deb_addver-$deb_appendver
	echo "Installation completed. Please sync && reboot"
}

echo "Hardkenrel's linux kernel installer for $deb_appendver"
echo -n "Continue ? [n] "
read yesno
if [ "$yesno" = "Y" ] || [ "$yesno" = "y" ]; then
    install_linux_image
else
    echo "You not do install linux image!"
    exit 0
fi
